#include "stm32f10x.h"
#include "stm32f10x_rcc.h"
#include "stm32f10x_gpio.h"
#include "system_stm32f10x.h"
#include "misc.h"

void GPIO_Configuration(void)
{
	GPIO_InitTypeDef GPIO_InitStructure;
	
	/* Configure IO connected to LD1, LD2, LD3 and LD4 leds *********************/	
	GPIO_InitStructure.GPIO_Pin = GPIO_Pin_2 | GPIO_Pin_3 | GPIO_Pin_4 | GPIO_Pin_7;
  	GPIO_InitStructure.GPIO_Mode = GPIO_Mode_Out_PP;
  	GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;
  	GPIO_Init(GPIOD, &GPIO_InitStructure);

   	/* Configure USART1 Tx (PA.09) as alternate function push-pull */
  	GPIO_InitStructure.GPIO_Pin = GPIO_Pin_9;
  	GPIO_InitStructure.GPIO_Mode = GPIO_Mode_AF_PP;
  	GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;
  	GPIO_Init(GPIOA, &GPIO_InitStructure);
    
  	/* Configure USART1 Rx (PA.10) as input floating */
  	GPIO_InitStructure.GPIO_Pin = GPIO_Pin_10;
  	GPIO_InitStructure.GPIO_Mode = GPIO_Mode_IN_FLOATING;
  	GPIO_Init(GPIOA, &GPIO_InitStructure);
}

//TR΋͍{
void NVIC_Configuration(void)
{ 
  	/* Configure the NVIC Preemption Priority Bits */  
  	NVIC_PriorityGroupConfig(NVIC_PriorityGroup_0);

	#ifdef  VECT_TAB_RAM  
	  /* Set the Vector Table base location at 0x20000000 */ 
	  NVIC_SetVectorTable(NVIC_VectTab_RAM, 0x0); 
	#else  /* VECT_TAB_FLASH  */
	  /* Set the Vector Table base location at 0x08000000 */ 
	  NVIC_SetVectorTable(NVIC_VectTab_FLASH, 0x0);   
	#endif
}

//TR,ڌ
void RCC_Configuration(void)
{
	SystemInit();	
	RCC_APB2PeriphClockCmd(RCC_APB2Periph_USART1 | RCC_APB2Periph_GPIOA 
                           |RCC_APB2Periph_GPIOB | RCC_APB2Periph_GPIOC
                           |RCC_APB2Periph_GPIOD | RCC_APB2Periph_GPIOE
						   |RCC_APB2Periph_ADC1  | RCC_APB2Periph_AFIO 
                           |RCC_APB2Periph_SPI1, ENABLE );
  // RCC_APB2PeriphClockCmd(RCC_APB2Periph_ALL ,ENABLE );
     RCC_APB1PeriphClockCmd(RCC_APB1Periph_TIM4 
                           |RCC_APB1Periph_USART3|RCC_APB1Periph_TIM2	                           
                           , ENABLE );
	 RCC_AHBPeriphClockCmd(RCC_AHBPeriph_DMA1, ENABLE);
}

void InitDis(void) 
{
   /* LCD Module init */
   //GLCD_init();
   //GLCD_clear(White);
   //GLCD_setTextColor(Blue);
   //GLCD_displayStringLn(Line1, "     GoldBull");
   //GLCD_displayStringLn(Line2, "   GPIO example");
   //GLCD_setTextColor(Red);
}

//o
void Init_All_Periph(void)
{
	RCC_Configuration();	
	InitDis();
//	GLCD_Test();
	GPIO_Configuration();
	NVIC_Configuration();
	//USART1_Configuration();
	//USART1Write((u8*)"    GoldBull  ADC_example ",sizeof("    GoldBull  GPIO_example "));
}

void Delay(vu32 nCount)
{
  for(; nCount != 0; nCount--);
}

int main(void)
{  
	Init_All_Periph();
 	while(1)
  	{
		/* Turn on LD1 */
    	GPIO_SetBits(GPIOD, GPIO_Pin_2);
    	/* Insert delay */
    	Delay(0xAFFFF);

    	/* Turn on LD2 and LD3 */
    	GPIO_SetBits(GPIOD, GPIO_Pin_3 | GPIO_Pin_4);
    	/* Turn off LD1 */
    	GPIO_ResetBits(GPIOD, GPIO_Pin_2);
    	/* Insert delay */
    	Delay(0xAFFFF);

    	/* Turn on LD4 */
    	GPIO_SetBits(GPIOD, GPIO_Pin_7);
    	/* Turn off LD2 and LD3 */
    	GPIO_ResetBits(GPIOD, GPIO_Pin_4 | GPIO_Pin_3);
    	/* Insert delay */
    	Delay(0xAFFFF);

    	/* Turn off LD4 */
    	GPIO_ResetBits(GPIOD, GPIO_Pin_7);	
  	}
}

