//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		floor_test.cpp
 * @brief		floor_test t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define _FILE_floor_test_CPP_

//======================================================================
// include
#include "test_helper.h"
#include "iris_math.h"
#include "iris_using.h"

#define IRIS_ALLEGREX(func)	iris_allegrex_##func

TEST(AllgrexTest, floorf)
{
	struct func
	{
		void operator ()(int r)
		{
			ASSERT_FLOAT_EQ( floorf((float)r)			, IRIS_ALLEGREX(floorf)((float)r) );
			ASSERT_FLOAT_EQ( floorf((float)r/RAND_MAX)	, IRIS_ALLEGREX(floorf)((float)r/RAND_MAX) );
			ASSERT_FLOAT_EQ( floorf(r*101.2f)			, IRIS_ALLEGREX(floorf)(r*101.2f) );
		}
	};
	randamloop(TESTNUM, func());
}

#undef IRIS_ALLEGREX
#define IRIS_ALLEGREX(func)	func

TEST(AllgrexTest, crt_floorf)
{
	struct func
	{
		void operator ()(int r)
		{
			ASSERT_FLOAT_EQ( floorf((float)r)			, IRIS_ALLEGREX(floorf)((float)r) );
			ASSERT_FLOAT_EQ( floorf((float)r/RAND_MAX)	, IRIS_ALLEGREX(floorf)((float)r/RAND_MAX) );
			ASSERT_FLOAT_EQ( floorf(r*101.2f)			, IRIS_ALLEGREX(floorf)(r*101.2f) );
		}
	};
	randamloop(TESTNUM, func());
}
