//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		rcp_test.cpp
 * @brief		rcp_test t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define _FILE_rcp_test_CPP_

//======================================================================
// include
#include "test_helper.h"
#include "iris_math.h"
#include "iris_using.h"

#define IRIS_ALLEGREX(func)	iris_allegrex_##func

TEST(AllgrexTest, rcp)
{
	struct func
	{
		void operator ()(int r)
		{
			ASSERT_FLOAT_EQ( rcpf((float)r)			, IRIS_ALLEGREX(rcpf)((float)r) );
			ASSERT_FLOAT_EQ( rcpf((float)r/RAND_MAX), IRIS_ALLEGREX(rcpf)((float)r/RAND_MAX) );
			ASSERT_FLOAT_EQ( rcpf(r*101.2f)			, IRIS_ALLEGREX(rcpf)(r*101.2f) );
		}
	};
	randamloop(TESTNUM, func());
}

#undef IRIS_ALLEGREX
#define IRIS_ALLEGREX(func)	func

TEST(AllgrexTest, crt_rcp)
{
	struct func
	{
		void operator ()(int r)
		{
			ASSERT_FLOAT_EQ( rcpf((float)r)			, IRIS_ALLEGREX(rcpf)((float)r) );
			ASSERT_FLOAT_EQ( rcpf((float)r/RAND_MAX), IRIS_ALLEGREX(rcpf)((float)r/RAND_MAX) );
			ASSERT_FLOAT_EQ( rcpf(r*101.2f)			, IRIS_ALLEGREX(rcpf)(r*101.2f) );
		}
	};
	randamloop(TESTNUM, func());
}
