//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		test_autoptr.cpp
 * @brief		FndAutoPtr eXg t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define _FILE_test_autoptr_CPP_

//======================================================================
// include
#include "unit/gt/gt_inchead.h"
#include "fnd/container/FndAutoPtr.h"
#include "iris_using.h"

TEST(FndAutoPtrTest, Func)
{
	int* p = new int(100);
	{
		CAutoPtr<int> ap1, ap2;
		ap1 = p;
		ASSERT_EQ( 100, *ap1 );
		ASSERT_TRUE( ap2.ptr() == nullptr );

		ap2 = ap1;

		ASSERT_TRUE( ap1.ptr() == nullptr );
		ASSERT_EQ( 100, *ap2 );
	}
}

