//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		test_autosingleton.cpp
 * @brief		FndAutoSingleton eXgt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define _IRIS_test_autosingleton_CPP_

//======================================================================
// include
#include "unit/gt/gt_inchead.h"
#include "fnd/container/FndAutoSingleton.h"
#include "fnd/container/FndAspectMT.h"
#include "iris_using.h"

//======================================================================
// class
class CAutoSingletonTest : public CAutoSingleton<CAutoSingletonTest>
{
public:
	int x;
};
class CPad : public CAutoSingleton<CPad, 4>
{
public:
	//CPad(s32 idx) : CAutoSingleton<CPad, 4>(idx) {}
public:
	int x, y;
};


//======================================================================
// test
TEST(FndAutoSingleton, Func)
{
	{
		// aspect test
		typedef CAspectual< CAutoSingletonTest::instance, CLogAspect<CAutoSingletonTest*> > CAutoSingletonAspect;
		{
			CAutoSingletonTest::instance inst1 = CAutoSingletonTest::CreateInstance();
			CAutoSingletonAspect asp1 = inst1;
			asp1->x = 10;
			CAutoSingletonTest::DeleteInstance();
			CAutoSingletonAspect inst2 = CAutoSingletonTest::CreateInstance();
			inst2->x = 20;
			ASSERT_TRUE( inst1.is_valid() );
		}
		ASSERT_TRUE( CAutoSingletonTest::is_valid() );

		{
			CAutoSingletonTest::instance inst1 = CAutoSingletonTest::GetInstance();
			inst1->x = 10;
			CAutoSingletonTest::instance inst2 = CAutoSingletonTest::GetInstance();
			inst2->x = 30;
			ASSERT_EQ( 30, inst1->x );
		}
		ASSERT_TRUE( CAutoSingletonTest::is_valid() );
		CAutoSingletonTest::DeleteInstance();
	}
	ASSERT_FALSE( CAutoSingletonTest::is_valid() );

	{
		//CPad pad(0);
		CPad::instance pad = CPad::CreateInstance(0);
		int x = pad->x;
		int y = pad->y;

		ASSERT_TRUE( CPad::GetInstancePtr(0) != nullptr );
		ASSERT_TRUE( CPad::GetInstancePtr(1) == nullptr );
		ASSERT_TRUE( CPad::GetInstancePtr(2) == nullptr );
		ASSERT_TRUE( CPad::GetInstancePtr(3) == nullptr );
		CPad::DeleteInstance(0);
	}
}

