//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		test_color.cpp
 * @brief		FndColor eXg t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define _FILE_test_color_CPP_

//======================================================================
// include
#include "unit/gt/gt_inchead.h"
#include "fnd/types/FndColor.h"
#include "iris_using.h"

TEST(FndColorTest, Construct)
{
	for( int i=0; i < 10000; ++i )
	{
		int R = rand() & 0xFF;
		int G = rand() & 0xFF;
		int B = rand() & 0xFF;
		COLORREF color = RGB(R, G, B);
		CCOLORREF clrref = color;
		ASSERT_EQ( R, clrref.r() );
		ASSERT_EQ( G, clrref.g() );
		ASSERT_EQ( B, clrref.b() );
		ASSERT_EQ( 0, clrref.a() );
	}
}

TEST(FndColorTest, Copy)
{
	COLORREF color = RGB(0xFF, 0xCC, 0x66);
	CCOLORREF clr1 = color;
	CARGB8888 clr2 = clr1;
	CRGBA8888 clr3 = clr2;

	IrisFColor fclr1 = (IrisFColor)clr1;
	IrisFColor fclr2 = (IrisFColor)clr2;
	IrisFColor fclr3 = (IrisFColor)clr3;
	ASSERT_FLOAT_EQ( 1.0f, fclr1.r );
	ASSERT_FLOAT_EQ( 0.8f, fclr1.g );
	ASSERT_FLOAT_EQ( 0.4f, fclr1.b );
	ASSERT_FLOAT_EQ( 0.0f, fclr1.a );

	ASSERT_FLOAT_EQ( 1.0f, fclr2.r );
	ASSERT_FLOAT_EQ( 0.8f, fclr2.g );
	ASSERT_FLOAT_EQ( 0.4f, fclr2.b );
	ASSERT_FLOAT_EQ( 0.0f, fclr2.a );

	ASSERT_FLOAT_EQ( 1.0f, fclr3.r );
	ASSERT_FLOAT_EQ( 0.8f, fclr3.g );
	ASSERT_FLOAT_EQ( 0.4f, fclr3.b );
	ASSERT_FLOAT_EQ( 0.0f, fclr3.a );
}
