//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		test_operator.cpp
 * @brief		FndOperator eXg t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define _FILE_test_operator_CPP_

//======================================================================
// include
#include "unit/gt/gt_inchead.h"
#include "fnd/container/FndOperator.h"
#include "iris_using.h"
#include "iris_debug.h"

#include "c++0x/cpp0x_type_traits.hpp"

// FndOperator eXg
// opposite
IRIS_STATIC_ASSERT( (cpp0x::is_same<CTrueOp, CFalseOp::opposite>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CFalseOp, CTrueOp::opposite>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CEqualOp, CNotEqualOp::opposite>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CLessOp, CGEqualOp::opposite>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CLEqualOp, CGreaterOp::opposite>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CGreaterOp, CLEqualOp::opposite>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CGEqualOp, CLessOp::opposite>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CNotEqualOp, CEqualOp::opposite>::value) );

// append
// CFalseOp
IRIS_STATIC_ASSERT( (cpp0x::is_same<CFalseOp::append<CFalseOp>::other, CFalseOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CFalseOp::append<CTrueOp>::other, CTrueOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CFalseOp::append<CEqualOp>::other, CEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CFalseOp::append<CLessOp>::other, CLessOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CFalseOp::append<CLEqualOp>::other, CLEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CFalseOp::append<CGreaterOp>::other, CGreaterOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CFalseOp::append<CGEqualOp>::other, CGEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CFalseOp::append<CNotEqualOp>::other, CNotEqualOp>::value) );

// CTrueOp
IRIS_STATIC_ASSERT( (cpp0x::is_same<CTrueOp::append<CFalseOp>::other, CFalseOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CTrueOp::append<CTrueOp>::other, CTrueOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CTrueOp::append<CEqualOp>::other, CEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CTrueOp::append<CLessOp>::other, CLessOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CTrueOp::append<CLEqualOp>::other, CLEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CTrueOp::append<CGreaterOp>::other, CGreaterOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CTrueOp::append<CGEqualOp>::other, CGEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CTrueOp::append<CNotEqualOp>::other, CNotEqualOp>::value) );

// CEqualOp
IRIS_STATIC_ASSERT( (cpp0x::is_same<CEqualOp::append<CFalseOp>::other, CFalseOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CEqualOp::append<CTrueOp>::other, CTrueOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CEqualOp::append<CEqualOp>::other, CEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CEqualOp::append<CLessOp>::other, CLEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CEqualOp::append<CLEqualOp>::other, CLEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CEqualOp::append<CGreaterOp>::other, CGEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CEqualOp::append<CGEqualOp>::other, CGEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CEqualOp::append<CNotEqualOp>::other, CTrueOp>::value) );

// CLessOp
IRIS_STATIC_ASSERT( (cpp0x::is_same<CLessOp::append<CFalseOp>::other, CFalseOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CLessOp::append<CTrueOp>::other, CTrueOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CLessOp::append<CEqualOp>::other, CLEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CLessOp::append<CLessOp>::other, CLessOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CLessOp::append<CLEqualOp>::other, CLEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CLessOp::append<CGreaterOp>::other, CNotEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CLessOp::append<CGEqualOp>::other, CTrueOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CLessOp::append<CNotEqualOp>::other, CLessOp>::value) );

// CLEqualOp
IRIS_STATIC_ASSERT( (cpp0x::is_same<CLEqualOp::append<CFalseOp>::other, CFalseOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CLEqualOp::append<CTrueOp>::other, CTrueOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CLEqualOp::append<CEqualOp>::other, CLEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CLEqualOp::append<CLessOp>::other, CLEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CLEqualOp::append<CLEqualOp>::other, CLEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CLEqualOp::append<CGreaterOp>::other, CTrueOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CLEqualOp::append<CGEqualOp>::other, CTrueOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CLEqualOp::append<CNotEqualOp>::other, CLessOp>::value) );

// CGreaterOp
IRIS_STATIC_ASSERT( (cpp0x::is_same<CGreaterOp::append<CFalseOp>::other, CFalseOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CGreaterOp::append<CTrueOp>::other, CTrueOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CGreaterOp::append<CEqualOp>::other, CGEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CGreaterOp::append<CLessOp>::other, CNotEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CGreaterOp::append<CLEqualOp>::other, CTrueOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CGreaterOp::append<CGreaterOp>::other, CGreaterOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CGreaterOp::append<CGEqualOp>::other, CGEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CGreaterOp::append<CNotEqualOp>::other, CGreaterOp>::value) );

// CGEqualOp
IRIS_STATIC_ASSERT( (cpp0x::is_same<CGEqualOp::append<CFalseOp>::other, CFalseOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CGEqualOp::append<CTrueOp>::other, CTrueOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CGEqualOp::append<CEqualOp>::other, CGEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CGEqualOp::append<CLessOp>::other, CTrueOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CGEqualOp::append<CLEqualOp>::other, CTrueOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CGEqualOp::append<CGreaterOp>::other, CGEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CGEqualOp::append<CGEqualOp>::other, CGEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CGEqualOp::append<CNotEqualOp>::other, CGreaterOp>::value) );

// CNotEqualOp
IRIS_STATIC_ASSERT( (cpp0x::is_same<CNotEqualOp::append<CFalseOp>::other, CFalseOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CNotEqualOp::append<CTrueOp>::other, CTrueOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CNotEqualOp::append<CEqualOp>::other, CTrueOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CNotEqualOp::append<CLessOp>::other, CLessOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CNotEqualOp::append<CLEqualOp>::other, CLessOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CNotEqualOp::append<CGreaterOp>::other, CGreaterOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CNotEqualOp::append<CGEqualOp>::other, CGreaterOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CNotEqualOp::append<CNotEqualOp>::other, CNotEqualOp>::value) );

// erase
// CFalseOp
IRIS_STATIC_ASSERT( (cpp0x::is_same<CFalseOp::erase<CFalseOp>::other, CFalseOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CFalseOp::erase<CTrueOp>::other, CFalseOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CFalseOp::erase<CEqualOp>::other, CFalseOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CFalseOp::erase<CLessOp>::other, CFalseOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CFalseOp::erase<CLEqualOp>::other, CFalseOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CFalseOp::erase<CGreaterOp>::other, CFalseOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CFalseOp::erase<CGEqualOp>::other, CFalseOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CFalseOp::erase<CNotEqualOp>::other, CFalseOp>::value) );

// CTrueOp
IRIS_STATIC_ASSERT( (cpp0x::is_same<CTrueOp::erase<CFalseOp>::other, CTrueOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CTrueOp::erase<CTrueOp>::other, CFalseOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CTrueOp::erase<CEqualOp>::other, CNotEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CTrueOp::erase<CLessOp>::other, CGEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CTrueOp::erase<CLEqualOp>::other, CGreaterOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CTrueOp::erase<CGreaterOp>::other, CLEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CTrueOp::erase<CGEqualOp>::other, CLessOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CTrueOp::erase<CNotEqualOp>::other, CEqualOp>::value) );

// CEqualOp
IRIS_STATIC_ASSERT( (cpp0x::is_same<CEqualOp::erase<CFalseOp>::other, CEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CEqualOp::erase<CTrueOp>::other, CFalseOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CEqualOp::erase<CEqualOp>::other, CFalseOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CEqualOp::erase<CLessOp>::other, CEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CEqualOp::erase<CLEqualOp>::other, CFalseOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CEqualOp::erase<CGreaterOp>::other, CEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CEqualOp::erase<CGEqualOp>::other, CFalseOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CEqualOp::erase<CNotEqualOp>::other, CEqualOp>::value) );

// CLessOp
IRIS_STATIC_ASSERT( (cpp0x::is_same<CLessOp::erase<CFalseOp>::other, CLessOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CLessOp::erase<CTrueOp>::other, CFalseOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CLessOp::erase<CEqualOp>::other, CLessOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CLessOp::erase<CLessOp>::other, CFalseOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CLessOp::erase<CLEqualOp>::other, CFalseOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CLessOp::erase<CGreaterOp>::other, CLessOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CLessOp::erase<CGEqualOp>::other, CLessOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CLessOp::erase<CNotEqualOp>::other, CLEqualOp>::value) );

// CLEqualOp
IRIS_STATIC_ASSERT( (cpp0x::is_same<CLEqualOp::erase<CFalseOp>::other, CLEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CLEqualOp::erase<CTrueOp>::other, CFalseOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CLEqualOp::erase<CEqualOp>::other, CLessOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CLEqualOp::erase<CLessOp>::other, CEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CLEqualOp::erase<CLEqualOp>::other, CFalseOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CLEqualOp::erase<CGreaterOp>::other, CLEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CLEqualOp::erase<CGEqualOp>::other, CLEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CLEqualOp::erase<CNotEqualOp>::other, CLEqualOp>::value) );

// CGreaterOp
IRIS_STATIC_ASSERT( (cpp0x::is_same<CGreaterOp::erase<CFalseOp>::other, CGreaterOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CGreaterOp::erase<CTrueOp>::other, CFalseOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CGreaterOp::erase<CEqualOp>::other, CGreaterOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CGreaterOp::erase<CLessOp>::other, CGreaterOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CGreaterOp::erase<CLEqualOp>::other, CGreaterOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CGreaterOp::erase<CGreaterOp>::other, CFalseOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CGreaterOp::erase<CGEqualOp>::other, CFalseOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CGreaterOp::erase<CNotEqualOp>::other, CGEqualOp>::value) );

// CGEqualOp
IRIS_STATIC_ASSERT( (cpp0x::is_same<CGEqualOp::erase<CFalseOp>::other, CGEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CGEqualOp::erase<CTrueOp>::other, CFalseOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CGEqualOp::erase<CEqualOp>::other, CGreaterOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CGEqualOp::erase<CLessOp>::other, CGEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CGEqualOp::erase<CLEqualOp>::other, CGEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CGEqualOp::erase<CGreaterOp>::other, CEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CGEqualOp::erase<CGEqualOp>::other, CFalseOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CGEqualOp::erase<CNotEqualOp>::other, CGEqualOp>::value) );

// CNotEqualOp
IRIS_STATIC_ASSERT( (cpp0x::is_same<CNotEqualOp::erase<CFalseOp>::other, CNotEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CNotEqualOp::erase<CTrueOp>::other, CFalseOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CNotEqualOp::erase<CEqualOp>::other, CNotEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CNotEqualOp::erase<CLessOp>::other, CNotEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CNotEqualOp::erase<CLEqualOp>::other, CNotEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CNotEqualOp::erase<CGreaterOp>::other, CNotEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CNotEqualOp::erase<CGEqualOp>::other, CNotEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CNotEqualOp::erase<CNotEqualOp>::other, CFalseOp>::value) );

//======================================================================
// test
TEST(FndOperatorTest, Func)
{
	ASSERT_TRUE( !CFalseOp()(0, 0) );
	ASSERT_TRUE( !CFalseOp()(1, 0) );
	ASSERT_TRUE( !CFalseOp()(0, 1) );

	ASSERT_TRUE(  CTrueOp()(0, 0) );
	ASSERT_TRUE(  CTrueOp()(1, 0) );
	ASSERT_TRUE(  CTrueOp()(0, 1) );

	ASSERT_TRUE(  CEqualOp()(0, 0) );
	ASSERT_TRUE( !CEqualOp()(1, 0) );
	ASSERT_TRUE( !CEqualOp()(0, 1) );

	ASSERT_TRUE( !CLessOp()(0, 0) );
	ASSERT_TRUE( !CLessOp()(1, 0) );
	ASSERT_TRUE(  CLessOp()(0, 1) );

	ASSERT_TRUE(  CLEqualOp()(0, 0) );
	ASSERT_TRUE( !CLEqualOp()(1, 0) );
	ASSERT_TRUE(  CLEqualOp()(0, 1) );

	ASSERT_TRUE( !CGreaterOp()(0, 0) );
	ASSERT_TRUE(  CGreaterOp()(1, 0) );
	ASSERT_TRUE( !CGreaterOp()(0, 1) );

	ASSERT_TRUE(  CGEqualOp()(0, 0) );
	ASSERT_TRUE(  CGEqualOp()(1, 0) );
	ASSERT_TRUE( !CGEqualOp()(0, 1) );

	ASSERT_TRUE( !CNotEqualOp()(0, 0) );
	ASSERT_TRUE(  CNotEqualOp()(1, 0) );
	ASSERT_TRUE(  CNotEqualOp()(0, 1) );
}

