//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		test_range.cpp
 * @brief		FndRange eXgt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define _IRIS_test_range_CPP_

//======================================================================
// include
#include "unit/gt/gt_inchead.h"
#include "fnd/container/FndRange.h"
#include <map>
#include "iris_using.h"

//======================================================================
// test
TEST(ContainerTest, Range)
{
	typedef CRange<int>					Range;
	Range range0(  0, 100);
	Range range1(100, 200);
	Range range2(195, 300);

	{
		typedef std::multimap<Range, int>	MAP;
		typedef std::pair<Range, int>		PAIR;

		MAP	map;
		map.insert(PAIR(range0, 0));
		map.insert(PAIR(range1, 1));
		map.insert(PAIR(range2, 2));

		size_t cnt = map.count(Range(50, 150));			// }b`L[̐擾
		MAP::iterator it = map.find(Range(50, 150));	// 
		ASSERT_TRUE( it != map.end() );
		ASSERT_EQ( 2, cnt );	// }b`L[̌eXg
		// z肳 value Ă邩̃eXg
		for( size_t i=0; i < cnt; ++i, ++it )
		{
			ASSERT_EQ( it->second, 0+i );
		}
	}

#if	defined(IRIS_MFC_VER)
	{
		typedef CMap<Range, Range&, int, int&>	MAP;

		MAP map;
	}
#endif
}
