//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		test_sort.cpp
 * @brief		sorteXgt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define _IRIS_test_sort_CPP_

//======================================================================
// include
#include "unit/gt/gt_inchead.h"
#include "fnd/container/FndSort.h"
#include "iris_iostream.h"
#include "iris_using.h"
#include <time.h>
#include <vector>

//======================================================================
// typedef
typedef u32	test_type;

//======================================================================
// define
//#define TEST_NUM		10000000	// eXg
//#define TEST_NUM		99999		// eXg
#define TEST_NUM		8192		// eXg

#define LINE_ELEM		16			// Ps̕\
#define SORT_CHECK(ary)	do {													\
	for( int i=0; i < TEST_NUM-1; ++i ) { IRIS_ASSERT( ary[i] <= ary[i+1] ); }	\
} while(0)

#define TEST_COUT(ary)	// z̕\
#ifndef TEST_COUT
#define TEST_COUT(ary)	do {												\
	for( int i=0, n=0, sz=(TEST_NUM+LINE_ELEM-1)/LINE_ELEM; i < sz; ++i ) {	\
		for( int j=0; j < LINE_ELEM && n < TEST_NUM; ++j, ++n )				\
			std::cout << std::setw(4) << ary[n];							\
		std::cout << std::endl;												\
	} std::cout << std::endl;												\
} while(0)
#endif

#if 1
// z
#define TEST_CODE(func, ary, cp, op)	do {						\
	for( int i=0; i < TEST_NUM; ++i ) cp[i] = ary[i];				\
	func(TEST_NUM, cp, op());										\
	TEST_COUT(cp);													\
	SORT_CHECK(cp);													\
} while(0)
typedef test_type	copy_type;
#else
// vector
#define TEST_CODE(func, ary, cp, op)	do {						\
	cp.resize(TEST_NUM);											\
	for( int i=0; i < TEST_NUM; ++i ) cp[i] = ary[i];				\
	func<std::vector<type>, type>(TEST_NUM, cp, op());				\
	TEST_COUT(cp);													\
	SORT_CHECK(cp);													\
} while(0)
typedef std::vector<test_type>	copy_type;
#endif

//======================================================================
// variable
static test_type s_r[TEST_NUM];
static copy_type s_cp[TEST_NUM];

class FndSortTest : public ::testing::Test
{
	virtual void SetUp() 
	{
		// eXgp̍쐬
		for( int i=0; i < TEST_NUM; ++i )
			s_r[i] = rand();
	}
	virtual void TearDown()
	{
	}
};

//======================================================================
// test
TEST_F(FndSortTest, SelectionSort)
{
	TEST_COUT(s_r);
	TEST_CODE(SelectionSort	, s_r, s_cp, CLessOp);
}

TEST_F(FndSortTest, BubbleSort)
{
	TEST_COUT(s_r);
	TEST_CODE(BubbleSort	, s_r, s_cp, CLessOp);
}

TEST_F(FndSortTest, InsertSort)
{
	TEST_COUT(s_r);
	TEST_CODE(InsertSort	, s_r, s_cp, CLEqualOp);
}

TEST_F(FndSortTest, MergeSort)
{
	TEST_COUT(s_r);
	TEST_CODE(MergeSort		, s_r, s_cp, CLessOp);
}

TEST_F(FndSortTest, QuickSort)
{
	TEST_COUT(s_r);
	TEST_CODE(QuickSort		, s_r, s_cp, CLessOp);
}

