//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		test_lasterror.cpp
 * @brief		test_lasterror t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define _FILE_test_lasterror_CPP_

//======================================================================
// include
#include "unit/gt/gt_inchead.h"
#include "platform/windows/win/base/WXError.h"
#include <tchar.h>
#include "iris_using.h"

TEST(LastErrorTest, ToString)
{
	{
		CLastError es(ERROR_SUCCESS);
		ASSERT_STREQ( TEXT("̑𐳂I܂B\r\n"), es.ToString() );
	}
	{
		CLastError es(ERROR_OPEN_FAILED);
		ASSERT_STREQ( TEXT("w肳ꂽfoCX܂̓t@CJ܂B\r\n"), es.ToString() );
	}
}

TEST(LastErrorTest, Scoped)
{
	LASTERROR error = GetLastError();

	{
		CScopedLastError le;
		SetLastError(99);
		CLastError es(le);

		{
			CScopedLastError le2;
			ASSERT_EQ( 99, le2 );

			SetLastError(1);
		}

		CLastError es2;
		ASSERT_EQ( 99, es2() );

		std::cout << es.ToStringA() << std::endl;
	}

	ASSERT_EQ( error, GetLastError() );
}
