//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		test_hid.cpp
 * @brief		CHID eXg t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define _FILE_test_hid_CPP_

//======================================================================
// include
#include "unit/gt/gt_inchead.h"
#include "platform/windows/win/base/WXError.h"
#include "platform/windows/win/device/WXHID.h"
#include "iris_using.h"
#include <tchar.h>

void	EnumHIDProc_print_test(LPCTSTR lpDevicePath
						  , PSP_DEVICE_INTERFACE_DATA pspid
						  , LPVOID lpUser)
{
	_putts(lpDevicePath);

	CHID hid;
	if( !hid.Open(lpDevicePath, 0, FILE_SHARE_READ | FILE_SHARE_WRITE
		, nullptr, OPEN_EXISTING, 0, nullptr) )
	{
		CScopedLastError err;
		CLastError es(err);
		_putts(es.ToString());
		return;
	}

	HIDD_ATTRIBUTES attr;
	ASSERT_TRUE( hid.GetAttributes(&attr) );
	_tprintf(TEXT("VenderID : %x\nProductID : %x\nVersionNumber : %d\n")
		, attr.VendorID, attr.ProductID, attr.VersionNumber);

	ASSERT_EQ( attr.VendorID		, hid.GetVendorID() );
	ASSERT_EQ( attr.ProductID		, hid.GetProductID() );
	ASSERT_EQ( attr.VersionNumber	, hid.GetVersionNumber() );
}
BOOL	EnumHIDProc_print(LPCTSTR lpDevicePath
						  , PSP_DEVICE_INTERFACE_DATA pspid
						  , LPVOID lpUser)
{
	EnumHIDProc_print_test(lpDevicePath, pspid, lpUser);
	return TRUE;
}

TEST(HIDTest, Enum)
{
	ASSERT_TRUE( CHID::EnumHID(EnumHIDProc_print, nullptr) );
}

