//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		main.cpp
 * @brief		main t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define _FILE_main_CPP_

//======================================================================
// include
#include "unit/gt/gt_inchead.h"
#include "physics/havok/HvkSystem.h"
#include "physics/havok/HvkWorld.h"
#include "physics/havok/HvkRigid.h"
#include "physics/havok/shape/HvkBoxShape.h"
#include "iris_using.h"

TEST(HavokTest, Func)
{
	CHavokSystem	system;
	CWorld			world;
	CBoxShape		box;

	// VXe
	system.Initialize();

	// [h쐬
	world.Create(hkpWorldCinfo::SIMULATION_TYPE_CONTINUOUS, 0.1f, 10000.0f
		, hkpWorldCinfo::SOLVER_TYPE_4ITERS_MEDIUM, hkVector4(0.0f, -9.8f, 0.0f));

	// 쐬
	box.Create(2000.0f, 20.0f, 2000.0f);
	CRigid rigid;
	rigid.Create(0.0f, box, hkpMotion::MOTION_FIXED, hkVector4(0.0f, -20.0f, 0.0f));
	world->addEntity(rigid);

	rigid.Delete();
	box.Delete();
	world.Delete();
}
