//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		test_tfpu_mtx22.cpp
 * @brief		MathTMatrix22 eXg t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define _FILE_test_tfpu_mtx22_CPP_

//======================================================================
// include
#include "unit/gt/gt_inchead.h"
#include "math/tfpu/MathTMatrix22.h"
#include "iris_using.h"

TEST(MathTMatrix22Test, Zero)
{
#define ZEROTEST(type, zero)	do {	\
		typedef IrisTMtx22<type> mtx22;	\
		mtx22 mtx;						\
		TFpuMtx22Zero(&mtx);			\
		ASSERT_EQ( zero, mtx.x.x );		\
		ASSERT_EQ( zero, mtx.x.y );		\
		ASSERT_EQ( zero, mtx.y.x );		\
		ASSERT_EQ( zero, mtx.y.y );		\
	} while(0)

	ZEROTEST(int	, 0);
	ZEROTEST(float	, 0.f);
	ZEROTEST(double	, 0.0);
}
