//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		test_tfpu_mtx33.cpp
 * @brief		MathTMatrix33 eXg t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define _FILE_test_tfpu_mtx33_CPP_

//======================================================================
// include
#include "unit/gt/gt_inchead.h"
#include "math/tfpu/MathTMatrix33.h"
#include "iris_using.h"

TEST(MathTMatrix33Test, Zero)
{
#define ZEROTEST(type, zero)	do {	\
		typedef IrisTMtx33<type> mtx33;	\
		mtx33 mtx;						\
		TFpuMtx33Zero(&mtx);			\
		ASSERT_EQ( zero, mtx.x.x );		\
		ASSERT_EQ( zero, mtx.x.y );		\
		ASSERT_EQ( zero, mtx.x.z );		\
		ASSERT_EQ( zero, mtx.y.x );		\
		ASSERT_EQ( zero, mtx.y.y );		\
		ASSERT_EQ( zero, mtx.y.z );		\
		ASSERT_EQ( zero, mtx.z.x );		\
		ASSERT_EQ( zero, mtx.z.y );		\
		ASSERT_EQ( zero, mtx.z.z );		\
	} while(0)

	ZEROTEST(int	, 0);
	ZEROTEST(float	, 0.f);
	ZEROTEST(double	, 0.0);
}
