//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		test_tfpu_vec3.cpp
 * @brief		MathTVector3 eXg t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define _FILE_test_tfpu_vec3_CPP_

//======================================================================
// include
#include "unit/gt/gt_inchead.h"
#include "math/tfpu/MathTVector3.h"
#include "iris_using.h"

TEST(MathTVector3Test, Zero)
{
#define ZEROTEST(type, zero)	do {	\
		typedef IrisTVec3<type> vec3;	\
		vec3 vec;						\
		TFpuVec3Zero(&vec);				\
		ASSERT_EQ( zero, vec.x );		\
		ASSERT_EQ( zero, vec.y );		\
		ASSERT_EQ( zero, vec.z );		\
	} while(0)

	ZEROTEST(int	, 0);
	ZEROTEST(float	, 0.f);
	ZEROTEST(double	, 0.0);
}
