//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		test_sortarray.cpp
 * @brief		CSortArray eXg t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define _FILE_test_sortarray_CPP_

//======================================================================
// include
#include "unit/gt/gt_inchead.h"
#include "platform/windows/mfc/container/MfcMultiMap.h"
#include "iris_using.h"

typedef CMultiMap<int, int, int, int, fnd::CVaugeLessOp> MultiMap;

TEST(MfcMultiMapTest, Add)
{
	MultiMap map;
	int n = ((rand() >> 8) & 0xFF) + 1;
	for( int i=0; i < n; ++i )
	{
		map.Add( MultiMap::CPair(rand(), rand()) );
	}

	ASSERT_EQ( n, map.GetSize() );
	ASSERT_EQ( n, map.GetCount() );

	int pre = map[0].key;
	for( int i=1; i < n; ++i )
	{
		ASSERT_LE(pre, map[i].key);
		pre = map[i].key;
	}
}
