//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		test_oggvorbis.cpp
 * @brief		oggvorbis eXgt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define _FILE_test_oggvorbis_CPP_

//======================================================================
// include
#include "unit/gt/gt_inchead.h"
#include "audio/format/oggvorbis/AXOggVorbisFile.h"
#include "iris_iostream.h"
#include "iris_global.h"
#include "iris_using.h"
#include <tchar.h>

TEST(OggVorbisTest, Open)
{
	COggFile oggfile;

	ASSERT_TRUE( oggfile.Open(_TEXT("..\\..\\..\\..\\data\\snd\\sample.ogg")) );

	vorbis_info* pvi = oggfile.GetInfo();

	ASSERT_NE( pvi, (void*)nullptr );

	ASSERT_EQ( 0		, pvi->version );
	ASSERT_EQ( 2		, pvi->channels );
	ASSERT_EQ( 44100	, pvi->rate );
	ASSERT_EQ( 0		, pvi->bitrate_upper );
	ASSERT_EQ( 160000	, pvi->bitrate_nominal );
	ASSERT_EQ( 0		, pvi->bitrate_lower );
	ASSERT_EQ( 0		, pvi->bitrate_window );

	WAVEFORMATEX wfex;
	wfex.cbSize = sizeof(WAVEFORMATEX);
	ASSERT_TRUE( oggfile.GetWaveFormatEx(&wfex) );

	ASSERT_EQ( sizeof(WAVEFORMATEX), wfex.cbSize );
	ASSERT_EQ( 2, wfex.nChannels );
	ASSERT_EQ( 44100, wfex.nSamplesPerSec );
	ASSERT_EQ( 16, wfex.wBitsPerSample );
	ASSERT_EQ( 4, wfex.nBlockAlign );
	ASSERT_EQ( 4*44100, wfex.nAvgBytesPerSec );
	ASSERT_EQ( WAVE_FORMAT_PCM, wfex.wFormatTag );
}


