//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		test_variant.cpp
 * @brief		variant eXgt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define _FILE_test_variant_CPP_

//======================================================================
// include
#include "unit/gt/gt_inchead.h"
#include "platform/windows/win/container/WXVariant.h"
#include "iris_iostream.h"
#include "iris_global.h"
#include "iris_using.h"
#include <tchar.h>

TEST(VariantTest, Info)
{
	ASSERT_EQ( VT_I1	, CVariant::VT<s8>::value );
	ASSERT_EQ( VT_UI1	, CVariant::VT<u8>::value );
	ASSERT_EQ( VT_I1	, CVariant::VT<c8>::value );

	ASSERT_EQ( VT_I2	, CVariant::VT<s16>::value );
	ASSERT_EQ( VT_UI2	, CVariant::VT<u16>::value );

	ASSERT_EQ( VT_I4	, CVariant::VT<s32>::value );
	ASSERT_EQ( VT_UI4	, CVariant::VT<u32>::value );

	ASSERT_EQ( VT_I8	, CVariant::VT<s64>::value );
	ASSERT_EQ( VT_UI8	, CVariant::VT<u64>::value );

	ASSERT_EQ( VT_INT	, CVariant::VT<int32_t>::value );
	ASSERT_EQ( VT_UINT	, CVariant::VT<uint32_t>::value );

	ASSERT_EQ( VT_R4	, CVariant::VT<float>::value );
	ASSERT_EQ( VT_R8	, CVariant::VT<double>::value );

	ASSERT_EQ( VT_VOID	, CVariant::VT<void>::value );

	ASSERT_EQ( VT_INT|VT_BYREF	, CVariant::VT<int*>::value );
	ASSERT_EQ( VT_I1|VT_BYREF	, CVariant::VT<char*>::value );
	ASSERT_EQ( VT_R8|VT_BYREF	, CVariant::VT<double*>::value );
}

TEST(VariantTest, Func)
{
	CVariant var;
	var = 4;

	ASSERT_TRUE( var == 4 );
	ASSERT_TRUE( var == 4.0 );
	ASSERT_TRUE( var == 4.0f );

	ASSERT_TRUE( (4    == var.value<int>()) );
	ASSERT_TRUE( (4.0  == var.value<double>()) );
	ASSERT_TRUE( (4.0f == var.value<float>()) );
}
