//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		AXALTypes.h
 * @brief		AXALʒ`t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_AXALTypes_H_
#define INCG_IRIS_AXALTypes_H_

//======================================================================
// include
#include "../../iris_inchead.h"

//======================================================================
// typedef
typedef struct ALCdevice_struct		IrisAXALCdevice;	//!< foCX\
typedef struct ALCcontext_struct	IrisAXALCcontext;	//!< ReLXg\

namespace iris {
namespace ax {
namespace al
{

//======================================================================
// typedef
typedef char			AXALBOOL;		//!< t8rbg
typedef char			AXALCHAR;		//!< t8rbg
typedef char			AXALS8;			//!< t8rbg
typedef int				AXALS32;		//!< t32rbg
typedef unsigned int	AXALU32;		//!< Ȃ32rbg
typedef int				AXALSIZEI;		//!< t32rbg
typedef int				AXALENUM;		//!< t32rbg
typedef int				AXALRESULT;		//!< t32rbg
typedef float			AXALF32;		//!< 32rbgPx_
typedef double			AXALF64;		//!< 64rbg{x_
typedef void			AXALVOID;		//!< void

typedef void			*LPAXALVOID;	//!< void |C^^
typedef char			*LPAXALSTR;		//!< |C^^
typedef const char		*LPCAXALSTR;	//!< |C^^

typedef char			AXALCCHAR;		//!< t8rbg
typedef char			AXALCBOOL;		//!< t8rbg


typedef IrisAXALCdevice		AXALCdevice;		//!< foCX\
typedef IrisAXALCdevice		*LPAXALCDEVICE;		//!< foCX\̃|C^^

typedef IrisAXALCcontext	AXALCcontext;		//!< ReLXg\
typedef IrisAXALCcontext	*LPAXALCCONTEXT;	//!< ReLXg\̃|C^^

//======================================================================
// enum
//! ReLXg̑ݒ肷tO
typedef enum AXAL_CONTEXTATTRFLAG
{
    AXAL_CAF_FREQUENCY		= 0x01,	//!< ~LVOo̓obt@̎g
    AXAL_CAF_REFRESH		= 0x02,	//!< tbVԊu
    AXAL_CAF_SYNC			= 0x04,	//!< ReLXg
    AXAL_CAF_MONO_SOURCES	= 0x08,	//!< mf[^
    AXAL_CAF_STEREO_SOURCES	= 0x10,	//!< XeIf[^
} AXAL_CAF;

//======================================================================
// struct
//! ReLXg̑
typedef struct tagAXLCONTEXTATTR
{
    AXALU32	fMask;			//!< lݒ肷tO
    AXALS32	nFrequency;		//!< ~LVOo̓obt@̎g(Hz)
    AXALS32	nRefresh;		//!< tbVԊu(Hz)
    AXALS32	nSync;			//!< ReLXg(AL_TRUE or AL_FALSE)
    AXALS32	nMonoSources;	//!< mf[^T|[g\[X̐
    AXALS32	nStereoSources;	//!< XeIf[^T|[g\[X̐
} AXALCONTEXTATTR, *LPAXALCONTEXTATTR;
typedef const AXALCONTEXTATTR	*LPCAXALCONTEXTATTR;


}	// end of namespace al
}	// end of namespace ax
}	// end of namespace iris

#endif
