//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		AXAudioBuffer.cpp
 * @brief		I[fBIobt@ t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_AXAudioBuffer_CPP_

//======================================================================
// include
#include "AXAudioBuffer.h"

namespace iris {
namespace ax
{

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CAXBuffer::CAXBuffer(void)
: m_pFile(nullptr)
{
}

/**********************************************************************//**
 *
 * RXgN^
 *
 ----------------------------------------------------------------------
 * @param [in]	pFile	= t@CNX
*//***********************************************************************/
CAXBuffer::CAXBuffer(IAXFile* pFile)
: m_pFile(pFile)
{
}

/**********************************************************************//**
 *
 * Ǎ
 *
 ----------------------------------------------------------------------
 * @param [in]	uSize	= Ǎ݃TCY
 * @return	
*//***********************************************************************/
bool CAXBuffer::Read(u32 uSize)
{
	if( m_pFile == nullptr ) return false;
	Dealloc();
	Alloc(uSize);
	if( m_pBuffer == nullptr ) return false;
	u32 read = (u32)m_pFile->ReadPCM(m_pBuffer, uSize);
	if( read == 0 ) return false;
	m_ReadSize = read;
	return true;
}

/**********************************************************************//**
 *
 * Ǎ
 *
 ----------------------------------------------------------------------
 * @param [in]	uSize	= Ǎ݃TCY
 * @return	
*//***********************************************************************/
bool CAXBuffer::Read(void)
{
	if( m_pFile == nullptr ) return false;
	u32 uSize = m_pFile->GetSizePCM();
	return Read(uSize);
}


}	// end of namespace ax
}	// end of namespace iris
