//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		AXAudioFile.h
 * @brief		I[fBIt@CC^[tFCX t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_AXAudioFile_H_
#define INCG_IRIS_AXAudioFile_H_

//======================================================================
// inculde
#include "../../iris_object.h"

//======================================================================
// struct
#if	!defined(_WAVEFORMATEX_)
#define _WAVEFORMATEX_
typedef IRIS_PACKED struct tWAVEFORMATEX
{
    IrisU16		wFormatTag;         /* format type */
    IrisU16		nChannels;          /* number of channels (i.e. mono, stereo...) */
    IrisU32		nSamplesPerSec;     /* sample rate */
    IrisU32		nAvgBytesPerSec;    /* for buffer estimation */
    IrisU16		nBlockAlign;        /* block size of data */
    IrisU16		wBitsPerSample;     /* number of bits per sample of mono data */
    IrisU16		cbSize;             /* the count in bytes of the size of */
                                    /* extra information (after cbSize) */
} WAVEFORMATEX, *PWAVEFORMATEX, NEAR *NPWAVEFORMATEX, FAR *LPWAVEFORMATEX;
#endif /* _WAVEFORMATEX_ */
#ifndef WAVE_FORMAT_PCM
#  define WAVE_FORMAT_PCM     1
#endif


namespace iris {
namespace ax
{

//======================================================================
// class
//! I[fBIt@CC^[tFCXNX
class IAXFile : public IIrisObject
{
public:
	// RXgN^
	IAXFile(void);
	// fXgN^
	virtual ~IAXFile(void);

public:
	// J
	bool			Open (LPTSTR fname);

	/**
	 * @name	ۃ\bh
	 * @{
	*/

	virtual	bool	OpenA(LPSTR  fname) = 0;
	virtual	bool	OpenW(LPWSTR fname) = 0;

	//! 
	virtual	void	Close(void) = 0;

public:
	//! PCMf[^̓ǂݎ
	virtual s32		ReadPCM(void* lpBuffer, u32 length)		= 0;

	//! WAVEFORMATEX̎擾
	virtual bool	GetWaveFormatEx(LPWAVEFORMATEX pwfex)	const	= 0;
	//! f[^TCY̎擾
	virtual	u32		GetSize(void)		const				= 0;
	//! PCMf[^TCY̎擾
	virtual u32		GetSizePCM(void)	const				= 0;

public:
	//! tell
	virtual s32		Tell(void)		const	= 0;
	//! tell time
	virtual f64		TellTime(void)	const	= 0;
	//! seek
	virtual	bool	Seek(s32 samples)		= 0;
	//! seek (time)
	virtual	bool	SeekTime(f64 time)		= 0;

	/**
	 * @}
	*/
};

}	// end of namespace ax
}	// end of namespace iris

#endif
