//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		AXOggVorbisFile.cpp
 * @brief		oggt@CNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_AXOggVorbisFile_CPP_

#ifdef _IRIS_SUPPORT_OGGVORBIS

//======================================================================
// inculde
#include "AXOggVorbisFile.h"
#include "AXOggVorbisError.h"

//======================================================================
// link
#if	defined(_WIN32)
#  if		(_IRIS_SUPPORT_OGGVORBIS == IRIS_DYNAMIC_LIB)
#    define	OV_LIBNAME_TYPE		""
#    define OV_LIBNAME_MODE		""
#    define OV_LIBNAME_VC		""
#    define OV_OPTION			""
#  else
#    define	OV_LIBNAME_TYPE		"_static"
#    if		defined(_MT)
#      if			defined(_DLL)
#        define OV_LIBNAME_MODE	"_md"
#      else
#        define OV_LIBNAME_MODE	"_mt"
#      endif
#    endif
#    if		IRIS_MSC_AT_LEAST(_MSC_VER_VC9)
#      define OV_LIBNAME_VC		"2008"
#    else
#      define OV_LIBNAME_VC		"2005"
#    endif
#    ifdef	_IRIS_DEBUG
#      define	OV_OPTION			"d"
#    else
#      if		defined(_IRIS_SUPPORT_SSE)
#        define OV_OPTION			"_sse"
#      elif	defined(_IRIS_SUPPORT_SSE2)
#        define OV_OPTION			"_sse2"
#      else
#        define OV_OPTION			""
#      endif
#    endif
#  endif
#  pragma comment ( lib, "libogg"		 OV_LIBNAME_TYPE OV_LIBNAME_MODE OV_LIBNAME_VC OV_OPTION ".lib" )
#  pragma comment ( lib, "libvorbis"	 OV_LIBNAME_TYPE OV_LIBNAME_MODE OV_LIBNAME_VC OV_OPTION ".lib" )
#  pragma comment ( lib, "libvorbisfile" OV_LIBNAME_TYPE OV_LIBNAME_MODE OV_LIBNAME_VC OV_OPTION ".lib" )
#endif

namespace iris {
namespace ax
{

//======================================================================
// class

/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
COggFile::COggFile(void)
{
	SecureZeroMemory(&m_File, sizeof(m_File));
	ov_clear(&m_File);
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
COggFile::~COggFile(void)
{
	Close();
}

/**********************************************************************//**
 *
 * J
 *
 ----------------------------------------------------------------------
 * @param [in]	fname	= t@CpX
 * @return	
*//***********************************************************************/
bool COggFile::OpenA(LPSTR  fname)
{
	AXOV_DO_CHECK_RESULT(ov_fopen(fname, &m_File), return false);
	return true;
}
/// COggFile::OpenA Q
bool COggFile::OpenW(LPWSTR fname)
{
	size_t len = wcslen(fname);
	LPSTR mbs = reinterpret_cast<LPSTR>(alloca(len+1));
	size_t size=0;
	wcstombs_s(&size, mbs, len+1, fname, _TRUNCATE);
	return OpenA(mbs);
}

/**********************************************************************//**
 *
 * 
 *
*//***********************************************************************/
void COggFile::Close(void)
{
	AXOV_CHECK_RESULT(ov_clear(&m_File));
}

/**********************************************************************//**
 *
 * PCMf[^̓ǂݎ
 *
 ----------------------------------------------------------------------
 * @param [out]	lpBuffer	= o̓obt@
 * @param [in]	length		= o̓obt@
 * @param [in]	sgned		= PCM̕(0:Ȃ, 1:)
 * @param [out]	bitstream	= Xg[Đ̈ʒu
 * @return	WJobt@TCY
*//***********************************************************************/
s32 COggFile::Decode(char* lpBuffer, int length, int sgned, int* bitstream)
{
#if		defined(OV_TREMOR)
	IRIS_UNUSED_VARIABLE(sgned);
#if		defined(OV_MINIMUM_CODE)
	IRIS_UNUSED_VARIABLE(bitstream);
	return ov_read(&m_File, lpBuffer, length);
#else
	return ov_read(&m_File, lpBuffer, length, bitstream);
#endif

#else
	return ov_read(&m_File, lpBuffer, length
#ifdef __BIG_ENDIAN__
		, 1
#else
		, 0
#endif
		, 2
		, sgned
		, bitstream);
#endif
}

/**********************************************************************//**
 *
 * PCMf[^̓ǂݎ
 *
 ----------------------------------------------------------------------
 * @param [out]	lpBuffer	= o̓obt@
 * @param [in]	length		= o̓obt@
 * @return	WJobt@TCY
*//***********************************************************************/
s32 COggFile::ReadPCM(void* lpBuffer, u32 length)
{
	int bitstream;
	u32 total = 0;
	while(1)
	{
		s32 size = Decode(static_cast<char*>(lpBuffer) + total, length-total, 1, &bitstream);
		if( size <= 0 )
		{
			AXOV_ERROR(size);
			break;
		}
		total += size;
		if( total >= length )
		{
			break;
		}
	}
	return total;
}

/**********************************************************************//**
 *
 * WAVEFORMATEX̎擾
 *
 ----------------------------------------------------------------------
 * @param [out]	pwfex	= WAVEFORMATEX
 * @return	
*//***********************************************************************/
bool COggFile::GetWaveFormatEx(LPWAVEFORMATEX pwfex)	const
{
	if( pwfex == nullptr ) return false;
#if defined(OV_TREMOR)
	vorbis_info* vi = &m_File.vi;
#else
	if( m_File.vi == nullptr ) return false;
	vorbis_info* vi = m_File.vi;
#endif
//	IRIS_ASSERT( pwfex->cbSize != sizeof(WAVEFORMATEX) );
	pwfex->nChannels		= vi->channels;
	pwfex->nSamplesPerSec	= static_cast<u32>(vi->rate);
	pwfex->wBitsPerSample	= 16;
	pwfex->nBlockAlign		= pwfex->wBitsPerSample * pwfex->nChannels / 8;
	pwfex->nAvgBytesPerSec	= pwfex->nBlockAlign * pwfex->nSamplesPerSec;
	pwfex->wFormatTag		= WAVE_FORMAT_PCM;
	return true;
}

/**********************************************************************//**
 *
 * f[^TCY̎擾
 *
 ----------------------------------------------------------------------
 * @return	f[^TCY
*//***********************************************************************/
u32 COggFile::GetSize(void)	const
{
#if		defined(OV_TREMOR)
	u32 size = static_cast<u32>(ov_raw_total(&m_File, -1));
	return size * m_File.vi.channels * 2;
#else
	if( m_File.vi == nullptr ) return 0;
	u32 size = static_cast<u32>(ov_raw_total(&m_File, -1));
	return size * m_File.vi->channels * 2;
#endif
}

/**********************************************************************//**
 *
 * PCMf[^TCY̎擾
 *
 ----------------------------------------------------------------------
 * @return	f[^TCY
*//***********************************************************************/
u32 COggFile::GetSizePCM(void)	const
{
#if		defined(OV_TREMOR)
	u32 size = static_cast<u32>(ov_pcm_total(&m_File, -1));
	return size * m_File.vi.channels * 2;
#else
	if( m_File.vi == nullptr ) return 0;
	u32 size = static_cast<u32>(ov_pcm_total(&m_File, -1));
	return size * m_File.vi->channels * 2;
#endif
}

/**********************************************************************//**
 *
 * tell
 *
 ----------------------------------------------------------------------
 * @return	V[Nʒu(TvP)
*//***********************************************************************/
s32 COggFile::Tell(void)	const
{
	return static_cast<s32>(ov_pcm_tell(&m_File));
}

/**********************************************************************//**
 *
 * tell time
 *
 ----------------------------------------------------------------------
 * @return	V[Nʒu(bP)
*//***********************************************************************/
f64 COggFile::TellTime(void)	const
{
	return static_cast<f64>(ov_time_tell(&m_File));
}

/**********************************************************************//**
 *
 * seek
 *
 ----------------------------------------------------------------------
 * @param [in]	samples	= TvP
 * @return	
*//***********************************************************************/
bool COggFile::Seek(s32 samples)
{
	AXOV_DO_CHECK_RESULT(ov_pcm_seek(&m_File, samples), return false);
	return true;
}

/**********************************************************************//**
 *
 * seek time
 *
 ----------------------------------------------------------------------
 * @param [in]	time	= bP
 * @return	
*//***********************************************************************/
bool COggFile::SeekTime(f64 time)
{
	AXOV_DO_CHECK_RESULT(ov_time_seek(&m_File, time), return false);
	return true;
}

/**********************************************************************//**
 *
 * t@C̎擾
 *
 ----------------------------------------------------------------------
 * @param [in]	link	= 
 * @return	t@C
*//***********************************************************************/
vorbis_info* COggFile::GetInfo(int link)
{
	return ov_info(&m_File, link);
}

/**********************************************************************//**
 *
 * Rg̎擾
 *
 ----------------------------------------------------------------------
 * @param [in]	link	= 
 * @return	Rg
*//***********************************************************************/
vorbis_comment* COggFile::GetComment(int link)
{
	return ov_comment(&m_File, link);
}

}	// end of namespace ax
}	// end of namespace iris

#if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))
#include "../../../unit/UnitCore.h"
#include "../../../fnd/memory/FndMemBuffer.h"
#include "../../al/AXALSystem.h"
#include "../../al/AXALBuffer.h"
#include "../../al/AXALPlayer.h"
#include "../../../iris_using.h"

//======================================================================
// define
#define STREAM_BUFFER_NUM	2
#define STREAM_BUFFER_SIZE	8*1024

//======================================================================
// test
IRIS_UNITTEST(CAXOggVorbisFileUnitTest, AXOggVorbisFileUnitTest)
{
	COggFile oggfile;
#ifdef _IRIS_SUPPORT_OPENAL
	CALSystem system = CALSystem::CreateImplement();
	CALPlayer player;
	CALBuffer buffer[STREAM_BUFFER_NUM];
#endif
	CHAR fname[MAX_PATH] = "../../data/snd/sample.ogg";

	if( !oggfile.OpenA(fname) )
	{
		return;
	}
	printf("file open %s.\n", fname);
	vorbis_info* pvi = oggfile.GetInfo();
	if( pvi != nullptr )
	{
		printf("oggvorbis info.\n");
		printf("version         %d\n", pvi->version);
		printf("channels        %d\n", pvi->channels);
		printf("rate            %d\n", pvi->rate);
		printf("bitrate_upper   %d\n", pvi->bitrate_upper);
		printf("bitrate_nominal %d\n", pvi->bitrate_nominal);
		printf("bitrate_lower   %d\n", pvi->bitrate_lower);
		printf("bitrate_window  %d\n", pvi->bitrate_window);
	}

#ifdef _IRIS_SUPPORT_OPENAL
	{
		WAVEFORMATEX wfex;
		oggfile.GetWaveFormatEx(&wfex);
		system.Initialize();
		player.Initialize();

		printf("play streaming.\n");

		fnd::CMemBuffer data[STREAM_BUFFER_NUM];
		for( int i=0; i < STREAM_BUFFER_NUM; ++i )
		{
			data[i].Alloc(STREAM_BUFFER_SIZE);
			s32 size = oggfile.ReadPCM(data[i], data[i].GetSize());
			buffer[i].Initialize();
			buffer[i].BindData(data[i], size, wfex.nChannels, wfex.nSamplesPerSec);

			player.StreamOut(&buffer[i], TRUE);
		}

		player.SetLoop(FALSE);
		player.Play();

		while( player.IsPlay() )
		{
			if( player.GetProcessedBufferNum() > 0 || player.GetQueueBufferNum() < STREAM_BUFFER_NUM )
			{
				player.Dequeue(1);
				for( int i=0; i < STREAM_BUFFER_NUM; ++i )
				{
					if( !buffer[i].IsRegistPlayer() )
					{
						s32 size = oggfile.ReadPCM(data[i], data[i].GetSize());
						if( size == 0 ) break;
						buffer[i].BindData(data[i], size, wfex.nChannels, wfex.nSamplesPerSec);
						player.StreamOut(&buffer[i], TRUE);
						player.Play();
						break;
					}
				}
			}
		}
	}
#endif
}

#endif

#endif

