//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		AXWavFile.cpp
 * @brief		wavt@CNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_AXWavFile_CPP_

//======================================================================
// inculde
#include "AXWavFile.h"
#include "../../../iris_debug.h"

namespace iris {
namespace ax
{

//======================================================================
// class

/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CWavFile::CWavFile(void)
: m_Offset(-1)
, m_Size(0)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CWavFile::~CWavFile(void)
{
	Close();
}

/**********************************************************************//**
 *
 * J
 *
 ----------------------------------------------------------------------
 * @param [in]	fname	= t@CpX
 * @return	
*//***********************************************************************/
bool CWavFile::OpenA(LPSTR  fname)
{
	if( !m_File.OpenA(fname, fnd::FOPEN_READ) ) return false;
	m_File.Read(&m_Header, sizeof(fnd::RIFF_FILE_CHUNK));
	if( m_Header.uID != fnd::RIFF_ID_FILE_CHUNK 
		|| m_Header.uForm != fnd::RIFF_FORM_WAVE ) 
	{
		m_File.Close();
		return false;
	}
	// format
	while(1)
	{
		fnd::RIFF_CHUNK_HEADER chunk;
		s32 seek = m_File.Tell();
		if( m_File.Read(&chunk, sizeof(fnd::RIFF_CHUNK_HEADER)) == 0 )
		{
			m_File.Close();
			return false;
		}
		if( chunk.uID == fnd::RIFF_ID_FMT_CHUNK )
		{
			m_File.Seek(seek, fnd::FILE_SEEK_SET);
			m_File.Read(&m_Format, sizeof(fnd::RIFF_FMT_CHUNK));
			break;
		}
		if( chunk.uID == fnd::RIFF_ID_DATA_CHUNK )
		{
			m_Offset = seek + sizeof(fnd::RIFF_CHUNK_HEADER);
			m_Size = (u32)chunk.Size;
		}
		m_File.Seek(chunk.Size, fnd::FILE_SEEK_CUR);
	}
	// data
	while(m_Offset == -1)
	{
		fnd::RIFF_CHUNK_HEADER chunk;
		s32 seek = m_File.Tell();
		if( m_File.Read(&chunk, sizeof(fnd::RIFF_CHUNK_HEADER)) == 0 )
		{
			m_File.Close();
			return false;
		}
		if( chunk.uID == fnd::RIFF_ID_DATA_CHUNK )
		{
			m_Offset = seek + sizeof(fnd::RIFF_CHUNK_HEADER);
			m_Size = static_cast<u32>(chunk.Size);
			break;
		}
		m_File.Seek(chunk.Size, fnd::FILE_SEEK_CUR);
	}
	m_File.Seek(m_Offset, fnd::FILE_SEEK_SET);
	return true;
}
/// CWavFile::OpenA Q
bool CWavFile::OpenW(LPWSTR fname)
{
	if( !m_File.OpenW(fname, fnd::FOPEN_READ) ) return false;
	m_File.Read(&m_Header, sizeof(fnd::RIFF_FILE_CHUNK));
	if( m_Header.uID != fnd::RIFF_ID_FILE_CHUNK 
		|| m_Header.uForm != fnd::RIFF_FORM_WAVE ) 
	{
		m_File.Close();
		return false;
	}
	// format
	while(1)
	{
		fnd::RIFF_CHUNK_HEADER chunk;
		s32 seek = m_File.Tell();
		if( m_File.Read(&chunk, sizeof(fnd::RIFF_CHUNK_HEADER)) == 0 )
		{
			m_File.Close();
			return false;
		}
		if( chunk.uID == fnd::RIFF_ID_FMT_CHUNK )
		{
			m_File.Seek(seek, fnd::FILE_SEEK_SET);
			m_File.Read(&m_Format, sizeof(fnd::RIFF_FMT_CHUNK));
			break;
		}
		if( chunk.uID == fnd::RIFF_ID_DATA_CHUNK )
		{
			m_Offset = seek + sizeof(fnd::RIFF_CHUNK_HEADER);
			m_Size = (u32)chunk.Size;
		}
		m_File.Seek(chunk.Size, fnd::FILE_SEEK_CUR);
	}
	// data
	while(m_Offset == -1)
	{
		fnd::RIFF_CHUNK_HEADER chunk;
		s32 seek = m_File.Tell();
		if( m_File.Read(&chunk, sizeof(fnd::RIFF_CHUNK_HEADER)) == 0 )
		{
			m_File.Close();
			return false;
		}
		if( chunk.uID == fnd::RIFF_ID_DATA_CHUNK )
		{
			m_Offset = seek + sizeof(fnd::RIFF_CHUNK_HEADER);
			m_Size = (u32)chunk.Size;
			break;
		}
		m_File.Seek(chunk.Size, fnd::FILE_SEEK_CUR);
	}
	m_File.Seek(m_Offset, fnd::FILE_SEEK_SET);
	return true;
}

/**********************************************************************//**
 *
 * 
 *
*//***********************************************************************/
void CWavFile::Close(void)
{
	m_File.Close();
	m_Offset = -1;
	m_Size = 0;
}

/**********************************************************************//**
 *
 * PCMf[^̓ǂݎ
 *
 ----------------------------------------------------------------------
 * @param [out]	lpBuffer	= o̓obt@
 * @param [in]	length		= o̓obt@
 * @return	WJobt@TCY
*//***********************************************************************/
s32 CWavFile::ReadPCM(void* lpBuffer, u32 length)
{
	s32 pos = m_File.Tell() - m_Offset;
	IRIS_ASSERT( pos >= 0 );
	if( pos + length > static_cast<u32>(m_Size) ) length = static_cast<u32>(m_Size - pos);
	s32 read = static_cast<s32>(m_File.Read(lpBuffer, length));
	return read;
}

/**********************************************************************//**
 *
 * WAVEFORMATEX̎擾
 *
 ----------------------------------------------------------------------
 * @param [out]	pwfex	= WAVEFORMATEX
 * @return	
*//***********************************************************************/
bool CWavFile::GetWaveFormatEx(LPWAVEFORMATEX pwfex)	const
{
	if( pwfex == nullptr ) return false;
	if( m_Size == 0 ) return false;
	pwfex->cbSize			= sizeof(WAVEFORMATEX);
	pwfex->nChannels		= (u16)m_Format.Channels;
	pwfex->nSamplesPerSec	= m_Format.SamplePerSec;
	pwfex->wBitsPerSample	= m_Format.BitsWidth;
	pwfex->nBlockAlign		= pwfex->wBitsPerSample * pwfex->nChannels / 8;
	pwfex->nAvgBytesPerSec	= pwfex->nBlockAlign * pwfex->nSamplesPerSec;
	pwfex->wFormatTag		= WAVE_FORMAT_PCM;
	return true;
}

/**********************************************************************//**
 *
 * tell
 *
 ----------------------------------------------------------------------
 * @return	V[Nʒu(TvP)
*//***********************************************************************/
s32 CWavFile::Tell(void)	const
{
	s32 pos = m_File.Tell();
	if( pos < m_Offset ) return -1;
	if( static_cast<u32>(pos) >= m_Offset + m_Size ) return -1;
	return (pos - m_Offset) / (m_Format.BitsWidth * m_Format.Channels);
}

/**********************************************************************//**
 *
 * tell time
 *
 ----------------------------------------------------------------------
 * @return	V[Nʒu(bP)
*//***********************************************************************/
f64 CWavFile::TellTime(void)	const
{
	s32 samples = Tell();
	if( samples == -1 ) return 0.0f;
	return (f64)samples / m_Format.SamplePerSec;
}

/**********************************************************************//**
 *
 * seek
 *
 ----------------------------------------------------------------------
 * @param [in]	samples	= TvP
 * @return	
*//***********************************************************************/
bool CWavFile::Seek(s32 samples)
{
	s32 pos = samples * m_Format.BitsWidth * m_Format.Channels;
	m_File.Seek(pos + m_Offset, fnd::FILE_SEEK_SET);
	return true;
}

/**********************************************************************//**
 *
 * seek time
 *
 ----------------------------------------------------------------------
 * @param [in]	time	= bP
 * @return	
*//***********************************************************************/
bool CWavFile::SeekTime(f64 time)
{
	s32 samples = static_cast<s32>(time * m_Format.SamplePerSec);
	s32 pos = samples * m_Format.BitsWidth * m_Format.Channels;
	 m_File.Seek(pos + m_Offset, fnd::FILE_SEEK_SET);
	return true;
}

}	// end of namespace ax
}	// end of namespace iris

#if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))
#include "../../../unit/UnitCore.h"
#include "../../al/AXALSystem.h"
#include "../../al/AXALBuffer.h"
#include "../../al/AXALPlayer.h"
#include <stdio.h>
#include "iris_using.h"

//======================================================================
// define
#define STREAM_BUFFER_NUM	2
#define STREAM_BUFFER_SIZE	8*1024

//======================================================================
// test
IRIS_UNITTEST(CAXWavFileUnitTest, AXWavFileUnitTest)
{
	CWavFile wavfile;
#ifdef _IRIS_SUPPORT_OPENAL
	CALSystem system = CALSystem::CreateImplement();
	CALPlayer player;
	CALBuffer buffer[STREAM_BUFFER_NUM];
#endif

	CHAR fname[MAX_PATH] = "../../data/snd/sample.wav";
	if( !wavfile.OpenA(fname) )
	{
		return;
	}
	printf("file open %s.\n", fname);

	const fnd::RIFF_FMT_CHUNK&	fmt = wavfile.GetFormatChunk();
	printf("wav info.\n");
	printf("channels      %d\n", fmt.Channels);
	printf("SamplePerSec  %d\n", fmt.SamplePerSec);
	printf("BitsWidth     %d\n", fmt.BitsWidth);
	printf("BytePerSec    %d\n", fmt.BytePerSec);
	printf("Size          %d\n", fmt.Size);
	printf("BlockAlign    %d\n", fmt.BlockAlign);

#ifdef _IRIS_SUPPORT_OPENAL
	{
		WAVEFORMATEX wfex;
		wavfile.GetWaveFormatEx(&wfex);
		system.Initialize();
		player.Initialize();

		printf("play streaming.\n");

		fnd::CMemBuffer data[STREAM_BUFFER_NUM];
		for( int i=0; i < STREAM_BUFFER_NUM; ++i )
		{
			data[i].Alloc(STREAM_BUFFER_SIZE);
			s32 size = wavfile.ReadPCM(data[i], data[i].GetSize());
			buffer[i].Initialize();
			buffer[i].BindData(data[i], size, wfex.nChannels, wfex.nSamplesPerSec);

			player.StreamOut(&buffer[i], TRUE);
		}
		player.SetLoop(FALSE);
		player.Play();

		while( player.IsPlay() )
		{
			if( player.GetProcessedBufferNum() > 0 || player.GetQueueBufferNum() < STREAM_BUFFER_NUM )
			{
				player.Dequeue(1);
				for( int i=0; i < STREAM_BUFFER_NUM; ++i )
				{
					if( !buffer[i].IsRegistPlayer() )
					{
						s32 size = wavfile.ReadPCM(data[i], data[i].GetSize());
						if( size == 0 ) break;
						buffer[i].BindData(data[i], size, wfex.nChannels, wfex.nSamplesPerSec);
						player.StreamOut(&buffer[i], TRUE);
						player.Play();
						break;
					}
				}
			}
		}
	}
#endif
}

#endif

