//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		AXWavFile.h
 * @brief		wavt@CNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_AXWavFile_H_
#define INCG_IRIS_AXWavFile_H_

//======================================================================
// inculde
#include "../AXAudioFile.h"
#include "../../../fnd/io/FndFile.h"
#include "../../../fnd/utility/FndRIFF.h"

namespace iris {
namespace ax
{

//======================================================================
// class
//! wavt@CNX
class CWavFile : public IAXFile
{
protected:
	fnd::CFile				m_File;		//!< t@C
	fnd::RIFF_FILE_CHUNK	m_Header;	//!< t@C`N
	fnd::RIFF_FMT_CHUNK		m_Format;	//!< tH[}bg`N
	s32						m_Offset;	//!< f[^܂ł̃ItZbg
	u32						m_Size;		//!< f[^TCY
public:
	// RXgN^
	CWavFile(void);
	// fXgN^
	~CWavFile(void);

public:
	// J
	virtual	bool	OpenA(LPSTR  fname);
	virtual	bool	OpenW(LPWSTR fname);

	// 
	virtual	void	Close(void);

public:
	// PCMf[^̓ǂݎ
	virtual s32		ReadPCM(void* lpBuffer, u32 length);

	// WAVEFORMATEX̎擾
	virtual bool	GetWaveFormatEx(LPWAVEFORMATEX pwfex)	const;

	/// fmt`N̎擾
	const fnd::RIFF_FMT_CHUNK&	GetFormatChunk(void)	const	{ return m_Format; }
	/// wavf[^̃TCY擾
	virtual	u32		GetSize(void)		const	{ return m_Size; }
	/// PCMf[^TCY̎擾
	virtual u32		GetSizePCM(void)	const	{ return m_Size; }
public:
	// tell
	virtual s32		Tell(void)	const;
	// tell time
	virtual f64		TellTime(void)	const;
	// seek
	virtual	bool	Seek(s32 samples);
	// seek (time)
	virtual	bool	SeekTime(f64 time);
};


}	// end of namespace ax
}	// end of namespace iris

#endif
