//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		AXXABuffer.h
 * @brief		XAudio buffer t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_AXXABuffer_H_
#define INCG_IRIS_AXXABuffer_H_

//======================================================================
// include
#include "../format/AXAudioBuffer.h"
#include "xaudio_inchead.h"

#if	defined(_IRIS_SUPPORT_XAUDIO2)

namespace iris {
namespace ax {
namespace xaudio
{

//======================================================================
// class
/// XAudio Buffer
class CXABuffer : public CAXBuffer
{
protected:
	XAUDIO2_BUFFER	m_Buffer;	//!< XAudio2 buffer
public:
	// RXgN^
	CXABuffer(void);
	CXABuffer(IAXFile* pFile);

public:
	/// 
	virtual	void	Initialize(void);

public:
	// f[^̓Ǎ
	virtual	bool	Read(u32 uSize);
	virtual	bool	Read(void);

public:
	LPXAUDIO2_BUFFER	GetXAudio2Buffer(void)	{ return &m_Buffer; }
};

}	// end of namespace xaudio
}	// end of namespace ax
}	// end of namespace iris

#endif

#endif
