//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		cpp0x_nullptr.h
 * @brief		c++0x nullptr t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_cpp0x_nullptr_H_
#define INCG_IRIS_cpp0x_nullptr_H_

//======================================================================
// include

#ifdef _IRIS_HAS_NULLPTR_T
#  undef _IRIS_HAS_NULLPTR_T
#endif

//======================================================================
// class
#if	defined(__cplusplus_cli)
// C++/CLI
#define	nullptr			0
#define	func_nullptr	0

#elif defined(__cplusplus)
// C++
#if		defined(_MSC_VER) && (_MSC_VER < 1400)
#define	nullptr			0
#define	func_nullptr	0

#elif	defined(_MSC_VER) && (_MSC_VER >= 1600)
#define func_nullptr	nullptr

#else

#if		(defined(_IRIS_DEBUG) && !defined(_IRIS_NOT_SUPPORT_NULLPTR))

#define _IRIS_HAS_NULLPTR_T	//!< nullptr_t ^̒`邱Ƃ
#if	defined(__MWERKS__)
static
#else
const
#endif
/**
 * @brief	NULL|C^^
 * @details	(@ref section_autoexp_nullptr "autoexp")
*/
class nullptr_t
{
	void operator & (void)	const ;						//!< AhXQƂ֎~
public:
	template<class _TC>
	operator _TC* (void) const			{ return 0; }	//!< 񃁃o^̃k|C^ɕϊ
	template<class _TC, class _TCM>
	operator _TCM _TC::* (void) const 	{ return 0; }	//!< Cӂ̃o^̃k|C^ɕϊ
#if	defined(__MWERKS__) || defined(__GNUC__)
	nullptr_t(void) {}
#endif
} nullptr;	//!< NULL|C^^

// ꕔ̃RpCŊ֐|C^Ƃ̔rFłȂ
#if		defined(__MWERKS__)
#  define	func_nullptr	0	
#else
#  define	func_nullptr	nullptr
#endif

#else
#  define	nullptr			0		// ReleaseRpC0ɂĂ
#  define	func_nullptr	0		// ReleaseRpC0ɂĂ
#endif

#endif

#else
// C
#  define	nullptr			((void *)0)
#  define	func_nullptr	((void *)0)
#endif

#endif

/**
 * @addtogroup	autoexp
 * @{
 * @addtogroup	Visualizer
 * @section		section_autoexp_nullptr		; nullptr_t
 * @code
;------------------------------------------------------------------------------
; nullptr_t
;------------------------------------------------------------------------------
nullptr_t {
	preview
	(
		0
	)
}
 * @endcode
 * @}
*/
