//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		cpp0x_type_traits.hpp
 * @brief		type_traits t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_cpp0x_type_traits_HPP_
#define INCG_IRIS_cpp0x_type_traits_HPP_

//======================================================================
// include
#include "type_traits/cpp0x_abstract_traits.hpp"
#include "type_traits/cpp0x_align_traits.hpp"
#include "type_traits/cpp0x_arithmetic_traits.hpp"
#include "type_traits/cpp0x_array_traits.hpp"
#include "type_traits/cpp0x_base_derived_traits.hpp"
#include "type_traits/cpp0x_compound_traits.hpp"
#include "type_traits/cpp0x_convertible_traits.hpp"
#include "type_traits/cpp0x_class_traits.hpp"
#include "type_traits/cpp0x_empty_traits.hpp"
#include "type_traits/cpp0x_enum_traits.hpp"
#include "type_traits/cpp0x_extent_traits.hpp"
#include "type_traits/cpp0x_function_traits.hpp"
#include "type_traits/cpp0x_fundamental_traits.hpp"
#include "type_traits/cpp0x_nothrow_traits.hpp"
#include "type_traits/cpp0x_object_traits.hpp"
#include "type_traits/cpp0x_pod_traits.hpp"
#include "type_traits/cpp0x_polymorphic_traits.hpp"
#include "type_traits/cpp0x_reference_traits.hpp"
#include "type_traits/cpp0x_rank_traits.hpp"
#include "type_traits/cpp0x_same_traits.hpp"
#include "type_traits/cpp0x_scalar_traits.hpp"
#include "type_traits/cpp0x_trivial_traits.hpp"
#include "type_traits/cpp0x_union_traits.hpp"
#include "type_traits/cpp0x_virtual_traits.hpp"
#include "type_traits/cpp0x_xf_traits.hpp"
#include "type_traits/cpp0x_value_traits.hpp"

//======================================================================
// declare
template<typename _TN>class is_char;			//!< charǂ
template<typename _TN>class is_s_char;			//!< signed charǂ
template<typename _TN>class is_u_char;			//!< unsigned charǂ
template<typename _TN>class is_char_traits;		//!< char ǂ

template<typename _TN>class is_wchar_t;			//!< wchar_tǂ

template<typename _TN>class is_short;			//!< shortǂ
template<typename _TN>class is_s_short;			//!< signed shortǂ
template<typename _TN>class is_u_short;			//!< unsigned shortǂ
template<typename _TN>class is_short_traits;	//!< short ǂ

template<typename _TN>class is_int;				//!< intǂ
template<typename _TN>class is_s_int;			//!< signed intǂ
template<typename _TN>class is_u_int;			//!< unsigned intǂ
template<typename _TN>class is_int_traits;		//!< int ǂ

template<typename _TN>class is_long;			//!< long ǂ
template<typename _TN>class is_s_long;			//!< signed long ǂ
template<typename _TN>class is_u_long;			//!< unsigned long ǂ
template<typename _TN>class is_long_traits;		//!< long ǂ

template<typename _TN>class is_long_long;		//!< long long ǂ
template<typename _TN>class is_s_long_long;		//!< signed long long ǂ
template<typename _TN>class is_u_long_long;		//!< unsigned long long ǂ
template<typename _TN>class is_long_long_traits;//!< long long ǂ

template<typename _TN>class is_float;			//!< floatǂ
template<typename _TN>class is_double;			//!< doubleǂ
template<typename _TN>class is_long_double;		//!< long doubleǂ

template<typename _TN>class is_array;			//!< z񂩂ǂ

template<typename _TN>class is_void;			//!< voidǂ

template<typename _TN>class is_enum;			//!< enumǂ

template<typename _TN>class is_class;			//!< classǂ
template<typename _TN>class is_union;			//!< unionǂ

template<class _TC>class is_abstract;			//!< ۃNXǂ
template<typename _TN>class is_pod;				//!< POD^ǂ
template<typename _TN>class is_polymorphic;		//!< z֐Ă邩ǂ
template<typename _TN>class is_empty;			//!< 󂩂ǂ
template<typename _TN>class is_object;			//!< IuWFNgǂ


template<typename _TN>class is_const;			//!< constǂ
template<typename _TN>class add_const;			//!< _TN  constǉ
template<typename _TN>class remove_const;		//!< _TNconst폜

template<typename _TN>class is_volatile;		//!< volatileǂ
template<typename _TN>class add_volatile;		//!< _TN  volatileǉ
template<typename _TN>class remove_volatile;	//!< _TNvolatile폜

template<typename _TN>class is_pointer;				//!< |C^[ǂ
template<typename _TN>class is_member_pointer;		//!< o[|C^[ǂ
template<typename _TN>class is_member_function_pointer;	//!< o[֐|C^[ǂ
template<typename _TN>class is_member_object_pointer;	//!< o[IuWFNg|C^[ǂ
template<typename _TN>class add_pointer;			//!< _TN  |C^[ǉ
template<typename _TN>class remove_pointer;			//!< _TN|C^[폜

template<typename _TN>class is_reference;		//!< QƂǂ
template<typename _TN>class add_reference;		//!< _TN  QƓǉ
template<typename _TN>class remove_reference;	//!< _TNQƓ폜

template<typename _TN>class add_cv;				//!< _TN  const volatileǉ
template<typename _TN>class remove_cv;			//!< _TNconst volatile폜


template<typename _TN>class is_signed;		//!< signed ǂ
template<typename _TN>class is_unsigned;	//!< unsigned ǂ

template<typename _TN>class is_integral;		//!< ǂ
template<typename _TN>class is_floating_point;	//!< ǂ

template<typename _TN>class is_arithmetic;		//!< Z^ǂ
template<typename _TN>class is_fundamental;		//!< Z^voidǂ
template<typename _TN>class is_scalar;			//!< XJ[^ǂ
template<typename _TN>class is_compound;		//!< XJ[^ǂ

template<typename _TN>class is_function;		//!< ֐ǂ
template<typename _TN>class function_traits;	//!< ֐

template<typename _TN, size_t N>class extent;	//!< z̎
template<typename _TN>class rank;				//!< z̎
template<typename _TN>class remove_extent;		//!< z̎P폜
template<typename _TN>class remove_all_extent;	//!< z̎Sč폜


template<typename _TN>class alignment_of;		//!< ^̃ACg̎擾
template<int Align>class type_with_alignment;	//!< w肵ACgTCY̌^

template<typename _TN1, typename _TN2>class is_same;		//!< ̌^ǂ
template<typename _From, typename _To>class is_convertible;	//!< ^ϊ\ǂ
template<typename _Base, typename _Derived>class is_base_and_derived;	//!< p֌Wɂ邩ǂ
template<typename _Base, typename _Derived>class is_base_of;			//!< p֌Wɂ邩ǂ

template<typename _TN>class has_trivial_constructor;	//!< IȃRXgN^邩
template<typename _TN>class has_trivial_copy;			//!< IȃRs[RXgN^邩
template<typename _TN>class has_trivial_assign;			//!< Iȑ邩
template<typename _TN>class has_trivial_destructor;		//!< IȃfXgN^邩

template<typename _TN>class has_nothrow_constructor;	//!< RXgN^OX[邩ǂ
template<typename _TN>class has_nothrow_copy;			//!< Rs[RXgN^OX[邩ǂ
template<typename _TN>class has_nothrow_assign;			//!< OX[邩ǂ

template<typename _TN>class has_virtual_destructor;		//!< zfXgN^邩

#endif
