//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		cpp0x_abstract_traits.hpp
 * @brief		ۃNX t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_cpp0x_abstract_traits_HPP_
#define INCG_IRIS_cpp0x_abstract_traits_HPP_

//======================================================================
// include
#include "cpp0x_class_traits.hpp"

namespace cpp0x
{

//======================================================================
// declare
template<class _TC>class is_abstract;			// ۃNXǂ

//======================================================================
// class
/// is abstract
template<class _TC>
class is_abstract
{
	template<class _TT>struct abstract_trait_impl
	{
		template<class _TU>
		static iml::detail::no_t	check_sig(_TU (*)[1]);
		template<class _TU>
		static iml::detail::yes_t	check_sig(...);
#ifdef __GNUC__
		enum { value = is_iml_yes_t(abstract_trait_impl<_TT>::template check_sig<_TT>(0)) };
#else
		enum { value = is_iml_yes_t(check_sig<_TT>(0)) };
#endif
	};

	template<bool b, typename TMP>struct abstract_selector
	{
		template<class _TU>struct rebind { typedef iml::detail::false_type type; };
	};
	template<typename TMP>struct abstract_selector<true, TMP>
	{
		template<class _TU>struct rebind { typedef abstract_trait_impl<_TU> type; };
	};

	template<class _TT>struct abstract_trait
	{
		typedef abstract_selector< is_class<_TT>::value, void >	selector;
		typedef typename selector::template rebind<_TT>			binder;
		typedef typename binder::type							type;
		enum { value = type::value };
	};

public:
	enum { value = abstract_trait<_TC>::value };
};

}	// end of namespace cpp0x

#endif
