//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		cpp0x_array_traits.hpp
 * @brief		z t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_cpp0x_array_traits_HPP_
#define INCG_IRIS_cpp0x_array_traits_HPP_

//======================================================================
// include
#include "cpp0x_cv_traits.hpp"

namespace cpp0x
{

//======================================================================
// declare
template<typename _TN>class is_array;			// z񂩂ǂ

//======================================================================
// class
/// is array
template<typename _TN>
class is_array
{
	template<typename _TT> struct array_trait 
		: public iml::detail::false_type		{};
	template<typename _TT> struct array_trait<_TT[]>
		: public iml::detail::true_type		{};
	template<typename _TT, size_t Nx> struct array_trait<_TT[Nx]>
		: public iml::detail::true_type		{};
	typedef typename remove_cv<_TN>::type	type;
public:
	enum { value = array_trait<type>::value };
};

}	// end of namespace cpp0x

#endif
