//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		cpp0x_const_traits.hpp
 * @brief		type_traits t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_cpp0x_const_traits_HPP_
#define INCG_IRIS_cpp0x_const_traits_HPP_

//======================================================================
// include
#include "cpp0x_type_traits_def.hpp"

namespace cpp0x
{

//======================================================================
// declare
template<typename _TN>class is_const;		// constǂ
template<typename _TN>class add_const;		// _TN  constǉ
template<typename _TN>class remove_const;	// _TNconst폜

//======================================================================
// class
/// is const
template<typename _TN>
class is_const 
{
	template<typename _TT> struct const_trait : public iml::detail::false_type	{};
	template<typename _TT> struct const_trait<_TT const> : public iml::detail::true_type {};
public:
	enum { value = const_trait<_TN>::value };
};

/// add const trait
IRIS_SET_TYPE_TRAITS_DEC(add_const, const);
/// remove const trait
IRIS_REMOVE_TYPE_TRAITS_DEC(remove_const, const);

}	// end of namespace cpp0x

//======================================================================
// include
#include "cpp0x_type_traits_undef.hpp"

#endif
