//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		cpp0x_convertible_traits.hpp
 * @brief		^ϊ`FbN t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_cpp0x_convertible_traits_HPP_
#define INCG_IRIS_cpp0x_convertible_traits_HPP_

//======================================================================
// include
#include "cpp0x_abstract_traits.hpp"
#include "cpp0x_arithmetic_traits.hpp"
#include "cpp0x_array_traits.hpp"
#include "cpp0x_void_traits.hpp"
#include "cpp0x_reference_traits.hpp"
#include "../../ml/iml_op.hpp"

namespace cpp0x
{

//======================================================================
// declare
template<typename _From, typename _To>class is_convertible;		// ^ϊ\ǂ

//======================================================================
// class
/// is convertible
template<typename _From, typename _To>
class is_convertible 
{
	template<typename _TFrom, typename TMP>struct does_convertible_exit
	{
		template<typename _TTo>struct result
		{
			static iml::detail::no_t	check(...);
			static iml::detail::yes_t	check(_TTo);
			static _TFrom				_from;
			enum { value = is_iml_yes_t(check(_from)) };
		};
	};
	template<typename TMP>struct does_convertible_exit<void, TMP>
	{
		template<typename _TTo>struct result
		{
			enum { value = is_void<_TTo>::value };
		};
	};

	template<typename _TFrom, typename _TTo>struct is_convertible_base_impl
		: public does_convertible_exit<_TFrom, void>:: template result<_TTo>	{};

	template<typename _TFrom, typename _TTo>struct is_convertible_impl
	{
		typedef typename add_reference<_TFrom>::type	ref_type;
		enum { value = iml::op_and< is_convertible_base_impl<ref_type, _TTo>::value
						, iml::op_not< is_array<_TTo>::value >::value
						>::value
		};
	};

	template<bool trivaial1, bool trivaial2, bool abstract_target, typename TMP>
	struct is_convertible_select
	{
		template<class _TF, class _TT>struct rebind
		{
			typedef is_convertible_impl<_TF, _TT>	type;
		};
	};

	template<typename TMP>
	struct is_convertible_select<true, true, false, TMP>
	{
		template<class _TF, class _TT>struct rebind
		{
			typedef iml::detail::true_type	type;
		};
	};

	template<typename TMP>
	struct is_convertible_select<false, false, true, TMP>
	{
		template<class _TF, class _TT>struct rebind
		{
			typedef iml::detail::false_type	type;
		};
	};

	template<typename TMP>
	struct is_convertible_select<true, false, true, TMP>
	{
		template<class _TF, class _TT>struct rebind
		{
			typedef iml::detail::false_type	type;
		};
	};

	template<typename _TFrom, typename _TTo>struct is_convertible_dispach
	{
		typedef is_convertible_select<
			  is_arithmetic<_TFrom>::value
			, is_arithmetic<_TTo>::value
			, is_abstract<_TTo>::value
			, void>		selector;
		typedef typename selector::template rebind<_TFrom, _TTo>	binder;
		typedef typename binder::type		type;
	};

public:
	enum { value = is_convertible_dispach<_From, _To>::type::value };
};

}	// end of namespace cpp0x

#endif
