//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		cpp0x_decimal_traits.hpp
 * @brief		 t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_cpp0x_decimal_traits_HPP_
#define INCG_IRIS_cpp0x_decimal_traits_HPP_

//======================================================================
// include
#include "cpp0x_cv_traits.hpp"
#include "cpp0x_type_traits_def.hpp"
#include "../../ml/op/iml_op_or.hpp"

namespace cpp0x
{

//======================================================================
// declare
template<typename _TN>class is_float;			// floatǂ
template<typename _TN>class is_double;			// doubleǂ
template<typename _TN>class is_long_double;		// long_doubleǂ
template<typename _TN>class is_floating_point;	// ǂ

//======================================================================
// class
/// is float
IRIS_IS_TYPE_TRAITS_DEC(is_float, float);
/// is double
IRIS_IS_TYPE_TRAITS_DEC(is_double, double);
/// is long double
IRIS_IS_TYPE_TRAITS_DEC(is_long_double, long double);

/// is floating point
template<typename _TN>
class is_floating_point
{
	typedef typename remove_cv<_TN>::type	type;
public:
	enum 
	{ 
		value = iml::op_or< is_float<type>::value
				, is_double<type>::value
				, is_long_double<type>::value >::value
	};
};

}	// end of namespace cpp0x

//======================================================================
// include
#include "cpp0x_type_traits_undef.hpp"

#endif
