//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		cpp0x_empty_traits.hpp
 * @brief		 t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_cpp0x_empty_traits_HPP_
#define INCG_IRIS_cpp0x_empty_traits_HPP_

//======================================================================
// include
#include "cpp0x_cv_traits.hpp"
#include "cpp0x_class_traits.hpp"
#include "../../ml/op/iml_op_or.hpp"

namespace cpp0x
{

//======================================================================
// declare
template<typename _TN>class is_empty;		// 󂩂ǂ

//======================================================================
// class
/// is empty
template<typename _TN>
class is_empty
{
	template<typename _TT>struct is_empty_helper_t1 : public _TT
	{
		is_empty_helper_t1();
		int i[256];
	};
	struct is_empty_helper_t2	{ int i[256]; };

	template<typename _TT, bool ic = false>struct is_empty_helper : public iml::detail::false_type {};
	template<typename _TT>struct is_empty_helper<_TT, true>
	{
		enum { value = (sizeof(is_empty_helper_t1<_TT>) == sizeof(is_empty_helper_t2)) };
	};

	template<typename _TT>struct is_empty_impl
	{
		typedef typename remove_cv<_TT>::type	ncvt;
		enum { value = iml::op_or<is_empty_helper<ncvt, is_class<_TT>::value>::value
			, IRIS_IS_EMPTY(ncvt)>::value };
	};

public:
	enum { value = is_empty_impl<_TN>::value };
};

}	// end of namespace cpp0x

#endif
