//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		cpp0x_extent_traits.hpp
 * @brief		z t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_cpp0x_extent_traits_HPP_
#define INCG_IRIS_cpp0x_extent_traits_HPP_

//======================================================================
// include
#include "cpp0x_cv_traits.hpp"

namespace cpp0x
{

//======================================================================
// declare
template<typename _TN, size_t N>class extent;	// z̎
template<typename _TN>class remove_extent;		// z̎P폜
template<typename _TN>class remove_all_extent;	// z̎Sč폜

//======================================================================
// class
/// extent
template<typename _TN, size_t N=0>
class extent
{
	template<typename _TT, size_t NN>
	struct extent_trait { enum { value = 0 }; };

	template<typename _TT, size_t R, size_t NN>
	struct extent_trait<_TT[R], NN> { enum { value = extent_trait<_TT, NN-1>::value }; };

	template<typename _TT, size_t R>
	struct extent_trait<_TT[R], 0> { enum { value = R }; };

#if	!defined(__MWERKS__)
	template<typename _TT, size_t NN>
	struct extent_trait<_TT[], NN> { enum { value = extent_trait<_TT, NN-1>::value }; };

	template<typename _TT>
	struct extent_trait<_TT[], 0> { enum { value = 0 }; };
#endif

	typedef typename remove_cv<_TN>::type	type;
public:
	enum { value = extent_trait<type, N>::value };
};

/// remove extent
template<typename _TN>
class remove_extent
{
	template<typename _TT>
	struct rem_extent { typedef _TT	type; };

	template<typename _TT, size_t R>
	struct rem_extent<_TT[R]> { typedef _TT	type; };

#if	!defined(__MWERKS__)
	template<typename _TT>
	struct rem_extent<_TT[]> { typedef _TT	type; };
#endif

public:
	typedef typename rem_extent<_TN>::type type;
};

/// remove all extent
template<typename _TN>
class remove_all_extent
{
	template<typename _TT>
	struct rem_extent { typedef _TT	type; };

	template<typename _TT, size_t R>
	struct rem_extent<_TT[R]>
	{ 
		typedef typename rem_extent<_TT>::type type;
	};

#if	!defined(__MWERKS__)
	template<typename _TT>
	struct rem_extent<_TT[]>
	{ 
		typedef typename rem_extent<_TT>::type type;
	};
#endif

public:
	typedef typename rem_extent<_TN>::type type;
};

}	// end of namespace cpp0x

#endif
