//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		cpp0x_fundamental_traits.hpp
 * @brief		Z^  void^ t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_cpp0x_fundamental_traits_HPP_
#define INCG_IRIS_cpp0x_fundamental_traits_HPP_

//======================================================================
// include
#include "cpp0x_decimal_traits.hpp"
#include "cpp0x_integer_traits.hpp"
#include "cpp0x_void_traits.hpp"
#include "../../ml/op/iml_op_or.hpp"

namespace cpp0x
{

//======================================================================
// declare
template<typename _TN>class is_fundamental;		// Z^voidǂ

//======================================================================
// class
/// is fundamental
template<typename _TN>
class is_fundamental 
{
public:
	enum
	{ 
		value = iml::op_or< is_integral<_TN>::value
				, is_floating_point<_TN>::value
				, is_void<_TN>::value >::value
	};
};

}	// end of namespace cpp0x

#endif
