//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		cpp0x_pointer_traits.hpp
 * @brief		type_traits t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_cpp0x_pointer_traits_HPP_
#define INCG_IRIS_cpp0x_pointer_traits_HPP_

//======================================================================
// include
#include "cpp0x_cv_traits.hpp"
#include "cpp0x_type_traits_def.hpp"

namespace cpp0x
{

//======================================================================
// declare
template<typename _TN>class is_pointer;			// |C^[ǂ
template<typename _TN>class is_member_pointer;	// o[|C^[ǂ
template<typename _TN>class is_member_function_pointer;	// o[֐|C^[ǂ
template<typename _TN>class is_member_object_pointer;	// o[IuWFNg|C^[ǂ
template<typename _TN>class add_pointer;	// _TN  |C^[ǉ
template<typename _TN>class remove_pointer;	// _TN|C^[폜

//======================================================================
// class
/// is pointer
template<typename _TN>
class is_pointer 
{
	template<typename _TT> struct pointer_trait : public iml::detail::false_type	{};
	template<typename _TT> struct pointer_trait<_TT*> : public iml::detail::true_type {};
	typedef typename remove_cv<_TN>::type	type;
public:
	enum { value = pointer_trait<type>::value };
};

/// is member pointer
template<typename _TN>
class is_member_pointer 
{
	template<typename _TT> struct pointer_trait : public iml::detail::false_type	{};
	template<typename _TT, class _TC> struct pointer_trait<_TT _TC::*> : public iml::detail::true_type	{};
	typedef typename remove_cv<_TN>::type	type;
public:
	enum { value = pointer_trait<type>::value };
};

/// is member function pointer
template<typename _TN>
class is_member_function_pointer 
{
	template<typename _TT> struct pointer_trait : public iml::detail::false_type	{};
	template<typename _TT, class _TC> 
	struct pointer_trait<_TT (_TC::*)(void)> : public iml::detail::true_type	{};
	template<typename _TT, class _TC> 
	struct pointer_trait<_TT (_TC::*)(...)> : public iml::detail::true_type	{};

	template<typename _TT, class _TC, typename _A1> 
	struct pointer_trait<_TT (_TC::*)(_A1)> : public iml::detail::true_type	{};
	template<typename _TT, class _TC, typename _A1> 
	struct pointer_trait<_TT (_TC::*)(_A1, ...)> : public iml::detail::true_type	{};

	template<typename _TT, class _TC, typename _A1, typename _A2> 
	struct pointer_trait<_TT (_TC::*)(_A1, _A2)> : public iml::detail::true_type	{};
	template<typename _TT, class _TC, typename _A1, typename _A2> 
	struct pointer_trait<_TT (_TC::*)(_A1, _A2, ...)> : public iml::detail::true_type	{};

	template<typename _TT, class _TC, typename _A1, typename _A2, typename _A3> 
	struct pointer_trait<_TT (_TC::*)(_A1, _A2, _A3)> : public iml::detail::true_type	{};
	template<typename _TT, class _TC, typename _A1, typename _A2, typename _A3> 
	struct pointer_trait<_TT (_TC::*)(_A1, _A2, _A3, ...)> : public iml::detail::true_type	{};

	template<typename _TT, class _TC, typename _A1, typename _A2, typename _A3
		, typename _A4>
	struct pointer_trait<_TT (_TC::*)(_A1, _A2, _A3, _A4)> : public iml::detail::true_type	{};
	template<typename _TT, class _TC, typename _A1, typename _A2, typename _A3
		, typename _A4>
	struct pointer_trait<_TT (_TC::*)(_A1, _A2, _A3, _A4, ...)> : public iml::detail::true_type	{};

	template<typename _TT, class _TC, typename _A1, typename _A2, typename _A3
		, typename _A4, typename _A5>
	struct pointer_trait<_TT (_TC::*)(_A1, _A2, _A3, _A4, _A5)> : public iml::detail::true_type	{};
	template<typename _TT, class _TC, typename _A1, typename _A2, typename _A3
		, typename _A4, typename _A5>
	struct pointer_trait<_TT (_TC::*)(_A1, _A2, _A3, _A4, _A5, ...)> : public iml::detail::true_type	{};

	template<typename _TT, class _TC, typename _A1, typename _A2, typename _A3
		, typename _A4, typename _A5, typename _A6>
	struct pointer_trait<_TT (_TC::*)(_A1, _A2, _A3, _A4, _A5
		, _A6)> : public iml::detail::true_type	{};
	template<typename _TT, class _TC, typename _A1, typename _A2, typename _A3
		, typename _A4, typename _A5, typename _A6>
	struct pointer_trait<_TT (_TC::*)(_A1, _A2, _A3, _A4, _A5
		, _A6, ...)> : public iml::detail::true_type	{};

	template<typename _TT, class _TC, typename _A1, typename _A2, typename _A3
		, typename _A4, typename _A5, typename _A6, typename _A7>
	struct pointer_trait<_TT (_TC::*)(_A1, _A2, _A3, _A4, _A5
		, _A6, _A7)> : public iml::detail::true_type	{};
	template<typename _TT, class _TC, typename _A1, typename _A2, typename _A3
		, typename _A4, typename _A5, typename _A6, typename _A7>
	struct pointer_trait<_TT (_TC::*)(_A1, _A2, _A3, _A4, _A5
		, _A6, _A7, ...)> : public iml::detail::true_type	{};

	template<typename _TT, class _TC, typename _A1, typename _A2, typename _A3
		, typename _A4, typename _A5, typename _A6, typename _A7, typename _A8>
	struct pointer_trait<_TT (_TC::*)(_A1, _A2, _A3, _A4, _A5
		, _A6, _A7, _A8)> : public iml::detail::true_type	{};
	template<typename _TT, class _TC, typename _A1, typename _A2, typename _A3
		, typename _A4, typename _A5, typename _A6, typename _A7, typename _A8>
	struct pointer_trait<_TT (_TC::*)(_A1, _A2, _A3, _A4, _A5
		, _A6, _A7, _A8, ...)> : public iml::detail::true_type	{};

	template<typename _TT, class _TC, typename _A1, typename _A2, typename _A3
		, typename _A4, typename _A5, typename _A6, typename _A7, typename _A8
		, typename _A9>
	struct pointer_trait<_TT (_TC::*)(_A1, _A2, _A3, _A4, _A5
		, _A6, _A7, _A8, _A9)> : public iml::detail::true_type	{};
	template<typename _TT, class _TC, typename _A1, typename _A2, typename _A3
		, typename _A4, typename _A5, typename _A6, typename _A7, typename _A8
		, typename _A9>
	struct pointer_trait<_TT (_TC::*)(_A1, _A2, _A3, _A4, _A5
		, _A6, _A7, _A8, _A9, ...)> : public iml::detail::true_type	{};

	template<typename _TT, class _TC, typename _A1, typename _A2, typename _A3
		, typename _A4, typename _A5, typename _A6, typename _A7, typename _A8
		, typename _A9, typename _A10>
	struct pointer_trait<_TT (_TC::*)(_A1, _A2, _A3, _A4, _A5
		, _A6, _A7, _A8, _A9, _A10)> : public iml::detail::true_type	{};
	template<typename _TT, class _TC, typename _A1, typename _A2, typename _A3
		, typename _A4, typename _A5, typename _A6, typename _A7, typename _A8
		, typename _A9, typename _A10>
	struct pointer_trait<_TT (_TC::*)(_A1, _A2, _A3, _A4, _A5
		, _A6, _A7, _A8, _A9, _A10, ...)> : public iml::detail::true_type	{};

	template<typename _TT, class _TC, typename _A1, typename _A2, typename _A3
		, typename _A4, typename _A5, typename _A6, typename _A7, typename _A8
		, typename _A9, typename _A10, typename _A11>
	struct pointer_trait<_TT (_TC::*)(_A1, _A2, _A3, _A4, _A5
		, _A6, _A7, _A8, _A9, _A10, _A11)> : public iml::detail::true_type	{};
	template<typename _TT, class _TC, typename _A1, typename _A2, typename _A3
		, typename _A4, typename _A5, typename _A6, typename _A7, typename _A8
		, typename _A9, typename _A10, typename _A11>
	struct pointer_trait<_TT (_TC::*)(_A1, _A2, _A3, _A4, _A5
		, _A6, _A7, _A8, _A9, _A10, _A11, ...)> : public iml::detail::true_type	{};

	template<typename _TT, class _TC, typename _A1, typename _A2, typename _A3
		, typename _A4, typename _A5, typename _A6, typename _A7, typename _A8
		, typename _A9, typename _A10, typename _A11, typename _A12>
	struct pointer_trait<_TT (_TC::*)(_A1, _A2, _A3, _A4, _A5
		, _A6, _A7, _A8, _A9, _A10, _A11, _A12)> : public iml::detail::true_type	{};
	template<typename _TT, class _TC, typename _A1, typename _A2, typename _A3
		, typename _A4, typename _A5, typename _A6, typename _A7, typename _A8
		, typename _A9, typename _A10, typename _A11, typename _A12>
	struct pointer_trait<_TT (_TC::*)(_A1, _A2, _A3, _A4, _A5
		, _A6, _A7, _A8, _A9, _A10, _A11, _A12, ...)> : public iml::detail::true_type	{};

	typedef typename remove_cv<_TN>::type	type;
public:
	enum { value = pointer_trait<type>::value };
};

/// is member object pointer
template<typename _TN>
class is_member_object_pointer 
{
public:
	enum { value = iml::op_and<
					  is_member_pointer<_TN>::value
					, iml::op_not< is_member_function_pointer<_TN>::value >::value
					>::value };
};

/// add pointer_trait
//IRIS_ADD_TYPE_TRAITS_DEC(add_pointer, *);
template<typename _TN>
class add_pointer 
{
	template<typename _TT> struct pointer_trait
	{
		typedef _TT		*type;
	};
	template<typename _TT> struct pointer_trait< _TT& >
	{
		typedef _TT		*type;
	};
public:
	typedef typename pointer_trait<_TN>::type	type;
};
/// remove pointer_trait
IRIS_REMOVE_TYPE_TRAITS_DEC(remove_pointer, *);

//======================================================================
// function
template<typename _TN>
bool	IsPointer(_TN)			{ return is_pointer<_TN>::value; }
template<typename _TN>
bool	IsMemberPointer(_TN)	{ return is_member_pointer<_TN>::value; }

}	// end of namespace cpp0x

//======================================================================
// include
#include "cpp0x_type_traits_undef.hpp"

#endif
