//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		cpp0x_value_traits.hpp
 * @brief		l t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_cpp0x_value_traits_HPP_
#define INCG_IRIS_cpp0x_value_traits_HPP_

//======================================================================
// include
#include "cpp0x_cv_traits.hpp"

namespace cpp0x
{

//======================================================================
// declare
template<typename _TN>class zero_traits;		// 0 
template<typename _TN>class one_traits;			// 1 

//======================================================================
// define
#define IRIS_VALUE_TRAITS_DEC(name)							\
	template<typename _TN>class name##_traits_impl {		\
		public:												\
			static const _TN	value;						\
	};														\
	template<typename _TN>class name##_traits {				\
		public:												\
			typedef typename remove_cv<_TN>::type	type;	\
			static const type	value;						\
	};														\
	template<typename _TN>									\
	const typename name##_traits<_TN>::type	name##_traits<_TN>::value	\
		= name##_traits_impl<typename remove_cv<_TN>::type>::value


//======================================================================
// class
/// 0 
IRIS_VALUE_TRAITS_DEC(zero);
/// 1 
IRIS_VALUE_TRAITS_DEC(one);

template<typename _TN>
const _TN	zero_traits_impl<_TN>::value	= 0;
template<typename _TN>
const _TN	one_traits_impl<_TN>::value		= 1;

}	// end of namespace cpp0x

#undef IRIS_VALUE_TRAITS_DEC

#endif
