//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		cpp0x_xf_traits.hpp
 * @brief		xf t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_cpp0x_xf_traits_HPP_
#define INCG_IRIS_cpp0x_xf_traits_HPP_

//======================================================================
// include
#include "cpp0x_cv_traits.hpp"
#include "cpp0x_type_traits_def.hpp"

namespace cpp0x
{

//======================================================================
// declare
template<typename _TN>class is_xf32;			// xf32ǂ
template<typename _TN>class is_xf64;			// xf64ǂ

//======================================================================
// class
/// is xf
IRIS_IS_TYPE_TRAITS_DEC(is_xf32, IrisXF32);
IRIS_IS_TYPE_TRAITS_DEC(is_xf64, IrisXF64);

/// is xf tarits 
template<typename _TN>
class is_xf_traits
{
	typedef typename remove_cv<_TN>::type	type;
public:
	enum { value = iml::op_or< is_xf32<type>::value 
					, is_xf64<type>::value >::value
	};
};


}	// end of namespace cpp0x

//======================================================================
// include
#include "cpp0x_type_traits_undef.hpp"

#endif
