//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndBase64.h
 * @brief		Base64ϊ֐t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndBase64_H_
#define INCG_IRIS_FndBase64_H_

//======================================================================
// include
#include "../../iris_inchead.h"

//======================================================================
// define
#define BASE64_HEADA	"=?iso-2022-jp?B?"
#define BASE64_FOOTA	"?="

#ifdef UNICODE
#define BASE64_HEAD		BASE64_HEADA
#define BASE64_FOOT		BASE64_FOOTA

#else
#define BASE64_HEAD		BASE64_HEADA
#define BASE64_FOOT		BASE64_FOOTA

#endif

namespace iris {
namespace fnd
{

//======================================================================
// function

// fR[h
u32 DecodeBase64(u8* pDst, u32 dst_size, const u8* pSrc, u32 src_size);
// GR[h
u32 EncodeBase64(u8* pDst, u32 dst_size, const u8* pSrc, u32 src_size);
// GR[h(wb_Atb^t)
u32 EncodeBase64Head(u8* pDst, u32 dst_size, const u8* pSrc, u32 src_size);

}	// end of namespace fnd
}	// end of namespace iris

#endif
