//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndArray.h
 * @brief		zNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndArray_H_
#define INCG_IRIS_FndArray_H_

//======================================================================
// include
#include "FndAllocator.h"
#include "FndIterator.h"
#include "../../iris_debug.h"

namespace iris {
namespace fnd
{

//======================================================================
// declare
template< typename _TN, s32 Size >class CFixedArray;
template< typename _TN, class _Allocator >class CArray;
template< typename _TN, class _Allocator >class CRingArray;

//======================================================================
// class
/**
 * @brief	ArrayCe[^x[X
 * @tparam	_TN	= z^
*/
template<typename _TN>
class CArrayIteratorBase : public IIteratorBase<_TN>
{
	typedef IIteratorBase<_TN>			_Mybase;
	typedef CArrayIteratorBase<_TN>		_Myt;
	IRIS_PP_USING_MYTYPENAME(node_ptr, _TN*, _Mybase);
public:
	//! RXgN^
	CArrayIteratorBase(void)	{}
	//! RXgN^
	CArrayIteratorBase(node_ptr node) : _Mybase(node) {}
protected:
	/// ̃m[hɐi߂
	void	inc(void)	{ ++this->m_pNode; }
	/// Õm[hɖ߂
	void	dec(void)	{ --this->m_pNode; }

};

/**
 * @brief	ŒTCYzNX
 * @tparam	_TN		= ž^
 * @tparam	Size	= z̗vf
*/
template< typename _TN, s32 Size >
class CFixedArray : public IIrisObject
{
	typedef CFixedArray<_TN, Size>	_Myt;
public:
	typedef _TN			value_type;	//!< z^
	typedef _TN			*value_ptr;	//!< z^|C^^
	typedef _TN			&value_ref;	//!< z^Qƌ^
	typedef const _TN	*const_ptr;
	typedef const _TN	&const_ref;
	typedef	CIterator<CArrayIteratorBase<_TN>, _TN, _TN&, _TN*>				iterator;
	typedef	CIterator<CArrayIteratorBase<_TN>, _TN, const _TN&, const _TN*>	const_iterator;

	enum 
	{ 
		SIZE = Size	//!< z̗vf
	};
protected:
	value_type			m_Array[SIZE];	//!< z
public:
	/**
	 * @brief	RXgN^
	*/
	CFixedArray(void) {}
	
	/**
	 * @brief	RXgN^
	 * @param [in] r = zNX
	*/
	template<s32 rSize>
	explicit CFixedArray(const CFixedArray<value_type, rSize>& r)
	{
		copy(r);
	}
	
	/**
	 * @brief	fXgN^
	*/
	~CFixedArray(void) {}

public:
	/**
	 * @brief	
	 * @param [in] r = zNX
	*/
	template<s32 rSize>
	_Myt&	operator = (const CFixedArray<value_type, rSize>& r)
	{
		copy(r);
		return *this;
	}
	
	/**
	 * @brief	Q
	 * @param [in] index = CfbNX
	 * @return value_ref
	*/
	value_ref	operator [] (s32 index)
	{
		IRIS_ASSERT( index >= 0 && index < SIZE );
		return m_Array[index];
	}

	/**
	 * @brief	Q
	 * @param [in] index = CfbNX
	 * @return value_ref
	*/
	const_ref	operator [] (s32 index) const
	{
		IRIS_ASSERT( index >= 0 && index < SIZE );
		return m_Array[index];
	}

public:
	/// 擪̃Ce[^擾
	iterator 		begin(void)			{ return m_Array; }
	const_iterator	begin(void) const	{ return m_Array; }
	
	/// I[̃Ce[^擾
	iterator		end(void)			{ return &m_Array[0] == nullptr ? nullptr : (m_Array + SIZE); }
	const_iterator	end(void) const		{ return &m_Array[0] == nullptr ? nullptr : (m_Array + SIZE); }

	/// 擪̃m[h擾
	value_ptr		front(void)			{ return &begin(); }
	const_ptr		front(void) const	{ return &begin(); }
	
	/// I[̃m[h擾
	value_ptr		back(void)			{ return &(--end()); }
	const_ptr		back(void) const	{ return &(--end()); }

public:
	/**
	 * @brief	fB[vRs[
	 * @param [in] r = zNX
	*/
	template<s32 rSize>
	void		copy(const CFixedArray<value_type, rSize>& r)
	{
		s32 _size = size();
		if( _size > r.size() ) _size = r.size;
		for( s32 i=0; i < _size; ++i )
		{
			m_Array[i] = r[i];
		}
	}

	/**
	 * @brief	vf̎擾
	 * @return	vf
	*/
	u32			size(void)	const { return SIZE; }
	
	/**
	 * @brief	z̃AhX擾
	 * @return	zAhX
	*/
	value_ptr	ptr(void)		{ return m_Array; }
	const_ptr	ptr(void) const { return m_Array; }
};


/**
 * @brief	zNX
 * @details	(@ref section_autoexp_CArray "autoexp")
 * @tparam	_TN			= ž^
 * @tparam	_Allocator	= AP[^^Cv
*/
template< typename _TN, class _Allocator=CNewAllocator<_TN> >
class CArray : public CAllocatorInstance<_Allocator>
{
	typedef CArray<_TN, _Allocator>	_Myt;
public:
	typedef _TN			value_type;	//!< z^
	typedef _TN			*value_ptr;	//!< z^|C^^
	typedef _TN			&value_ref;	//!< z^Qƌ^
	typedef const _TN	*const_ptr;
	typedef const _TN	&const_ref;
	typedef	CIterator<CArrayIteratorBase<_TN>, _TN, _TN&, _TN*>				iterator;
	typedef	CIterator<CArrayIteratorBase<_TN>, _TN, const _TN&, const _TN*>	const_iterator;
protected:
	value_ptr	m_pArray;	//!< zAhX
	u32			m_nSize;	//!< vf

public:
	/**
	 * @brief	RXgN^
	*/
	CArray(void) : m_pArray(nullptr), m_nSize(0) {}
	
	/**
	 * @brief	RXgN^
	 * @param [in] size = vf
	*/
	explicit CArray(u32 size) : m_pArray(nullptr), m_nSize(0)
	{
		reserve(size);
	}

	/**
	 * @brief	RXgN^
	 * @param [in] r = zNX
	*/
	explicit CArray(const _Myt& r) : m_pArray(nullptr), m_nSize(0)
	{
		copy(r);
	}
	
	/**
	 * @brief	fXgN^
	*/
	virtual ~CArray(void)
	{
		release();
	}

public:
	/**
	 * @brief	LXg
	*/
	operator value_ptr (void)
	{
		return m_pArray;
	}

	/**
	 * @brief	
	 * @param [in] r = zNX
	*/
	_Myt&		operator = (const _Myt& r)
	{
		copy(r);
		return *this;
	}
	
	/**
	 * @brief	Q
	 * @param [in] index = CfbNX
	 * @return value_ref
	*/
	value_ref	operator [] (int index)
	{
		IRIS_ASSERT( index >= 0 && (u32)index < m_nSize );
		return m_pArray[index];
	}
	value_ref	operator [] (u32 index)
	{
		IRIS_ASSERT( index < m_nSize );
		return m_pArray[index];
	}

	/**
	 * @brief	Q
	 * @param [in] index = CfbNX
	 * @return value_ref
	*/
	const_ref	operator [] (int index) const
	{
		IRIS_ASSERT( index >= 0 && (u32)index < m_nSize );
		return m_pArray[index];
	}
	const_ref	operator [] (u32 index) const
	{
		IRIS_ASSERT( index < m_nSize );
		return m_pArray[index];
	}

public:
	/// 擪̃Ce[^擾
	iterator 		begin(void)			{ return m_pArray; }
	const_iterator	begin(void) const	{ return m_pArray; }
	
	/// I[̃Ce[^擾
	iterator		end(void)			{ return m_pArray == nullptr ? nullptr : (m_pArray + m_nSize); }
	const_iterator	end(void) const		{ return m_pArray == nullptr ? nullptr : (m_pArray + m_nSize); }

	/// 擪̃m[h擾
	value_ptr		front(void)			{ return &begin(); }
	const_ptr		front(void) const	{ return &begin(); }
	
	/// I[̃m[h擾
	value_ptr		back(void)			{ return &(--end()); }
	const_ptr		back(void) const	{ return &(--end()); }

	/// zvf̎擾
	value_ref		at(int index)			{ IRIS_ASSERT( index >= 0 && (u32)index < m_nSize ); return m_pArray[index]; }
	const_ref		at(int index)	const	{ IRIS_ASSERT( index >= 0 && (u32)index < m_nSize ); return m_pArray[index]; }

	/**
	 * @brief ۂǂ
	 * @retval	true	= 
	*/
	bool			empty(void) const	{ return m_pArray == nullptr; }
public:
	/**
	 * @brief	fB[vRs[
	 * @param [in] r = zNX
	*/
	void		copy(const _Myt& r)
	{
		release();
		const u32 _size = r.size();
		if( _size > 0 )
		{
			m_pArray = alloc(_size);
			m_nSize = _size;
			for( u32 i=0; i < _size; ++i )
			{
				m_pArray[i] = r[i];
			}
		}
	}

	/**
	 * @brief	vf̎擾
	 * @return	vf
	*/
	u32			size(void)	const { return m_nSize; }
	
	/**
	 * @brief	z̃AhX擾
	 * @return	zAhX
	*/
	value_ptr	ptr(void)		{ return m_pArray; }
	const_ptr	ptr(void) const { return m_pArray; }
	
	/**
	 * @brief	
	*/
	void			release(void)
	{
		m_nSize = 0;
		dealloc(m_pArray);
		m_pArray = nullptr;
	}
	
	/**
	 * @brief	z̊m
	 * @param [in] size = Vvf
	*/
	void			reserve(u32 size)
	{
		release();
		if( size > 0 )
		{
			m_pArray = alloc(size);
			m_nSize = size;
		}
	}

	/**
	 * @brief	zvf̕ύX
	 * @param [in] size = Vvf
	*/
	void			resize(u32 size)
	{
		_Myt tmp(*this);
		release();
		if( size > 0 )
		{
			m_pArray = alloc(size);
			for( u32 i=0; i < tmp.m_nSize && i < size; ++i )
			{
				m_pArray[i] = tmp[i];
			}
			m_nSize = size;
		}
	}
	
private:
	/**
	 * @brief	AP[g
	*/
	value_ptr	alloc(u32 size)
	{
		return static_cast<value_ptr>(this->allocator().alloc(size));
	}
	/**
	 * @brief	
	*/
	void		dealloc(value_ptr ptr)
	{
		this->allocator().dealloc(ptr);
	}
};

/**
 * @brief	zNX
 * @tparam	_TN			= ž^
 * @tparam	_Allocator	= AP[^^Cv
*/
template< typename _TN, class _Allocator=CNewAllocator<_TN> >
class CRingArray : public CArray<_TN, _Allocator>
{
	typedef CRingArray<_TN, _Allocator>	_Myt;
	typedef CArray<_TN, _Allocator>		_Mybase;

	IRIS_PP_USING_MYTYPENAME(value_ref, _TN&, _Mybase);
	IRIS_PP_USING_MYTYPENAME(const_ref, const _TN&, _Mybase);
	
public:
	/**
	 * @brief	RXgN^
	*/
	CRingArray(void) : _Mybase() {}
	
	/**
	 * @brief	RXgN^
	 * @param [in] size = vf
	*/
	explicit CRingArray(u32 size) : _Mybase(size)	{}

	/**
	 * @brief	RXgN^
	 * @param [in] r = zNX
	*/
	explicit CRingArray(const _Myt& r) : _Mybase(r)	{}
	
	/**
	 * @brief	fXgN^
	*/
	virtual ~CRingArray(void)	{}

public:
	/**
	 * @brief	Q
	 * @param [in] index = CfbNX
	 * @return value_ref
	*/
	value_ref	operator [] (int index)
	{
		index %= this->m_nSize;
		while( index < 0 ) { index = m_nSize + index; }
		return this->m_pArray[index];
	}

	/**
	 * @brief	Q
	 * @param [in] index = CfbNX
	 * @return value_ref
	*/
	const_ref	operator [] (int index) const
	{
		index %= this->m_nSize;
		while( index < 0 ) { index = m_nSize + index; }
		return this->m_pArray[index];
	}
};

}	// end of namespace fnd
}	// end of namespace iris

#endif

/**
 * @addtogroup	autoexp
 * @{
 * @addtogroup	Visualizer
 * @section		section_autoexp_CArray		; iris::fnd::CArray
 * @code
;------------------------------------------------------------------------------
; iris::fnd::CArray
;------------------------------------------------------------------------------
iris::fnd::CArray<*> {
	children
	(
		#(
			[actual members]: [$e,!],
			m_nSize : $e.m_nSize,
			#array 
			(
				expr : ($e.m_pArray)[$i],
				size : $e.m_nSize
			)
		)
	)
	preview
	(
		#(
			"[", $e.m_nSize, "](",
			#array
			(
				expr : ($e.m_pArray)[$i],
				size : $e.m_nSize
			),
			")"
		)
	)
}
 * @endcode
 * @}
*/