//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndAspect.h
 * @brief		AhXQƑǑmt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndAspect_H_
#define INCG_IRIS_FndAspect_H_

//======================================================================
// include
#include "../../iris_object.h"
#include "../../iris_debug.h"

namespace iris {
namespace fnd
{

//======================================================================
// declare
template<typename _TN, typename NextAspect> class IAspect;
template<typename _TN, typename NextAspect> class CLogAspect;
template<typename _TN, typename Aspect> class CAspectual;

//======================================================================
// class
/**
 * @brief	AhXQƑǑmNX
 * @tparam	_TN			= mΏی^
 * @tparam	NextAspect	= ̌mNX^
*/
template<typename _TN, typename NextAspect=_TN> 
class IAspect : IIrisObject
{
protected:
	typedef _TN		value_type;	//!< QƂ^
	value_type		m_ptr;		//!< QƂAhX
protected:
	/// RXgN^
	IAspect(value_type ptr) : m_ptr(ptr) {}
public:
	/// A[Zq
	NextAspect operator -> (void)
	{
		return m_ptr;
	}
};

/**
 * @brief	AhXQƎɃOo͂NX
 * @tparam	_TN			= mΏی^
 * @tparam	NextAspect	= ̌mNX^
*/
template<typename _TN, typename NextAspect=_TN> 
class CLogAspect : public IAspect<_TN, NextAspect>
{
	typedef IAspect<_TN, NextAspect>	_Mybase;
public:
	typedef _TN	value_type;
public:
	/// RXgN^
	CLogAspect(value_type ptr) : _Mybase(ptr) 
	{
		dprintfA("Refer to the address.        0x%.8x --->> \n", (u32w64)ptr);
	}
	/// fXgN^
	~CLogAspect(void)
	{
		dprintfA("The address was referred to. 0x%.8x <<--- \n", (u32w64)this->m_ptr);
	}
};

/**
 * @brief	AhXQƑǑmIuWFNg^NX
 * @tparam	_TN			= mΏی^
 * @tparam	NextAspect	= ̌mNX^
*/
template<typename _TN, typename Aspect=_TN> 
class CAspectual : IIrisObject
{
	typedef _TN	value_type;	//!< QƂ^
	value_type	m_ptr;		//!< QƂAhX
public:
	/// RXgN^
	CAspectual(value_type ptr) : m_ptr(ptr) {}
	/// A[Zq
	Aspect operator -> (void)
	{
		return Aspect(m_ptr);
	}
};

}	// end of namespace fnd
}	// end of namespace iris

#endif
