//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndAutoPtr.h
 * @brief		I[g|C^NXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndAutoPtr_H_
#define INCG_IRIS_FndAutoPtr_H_

//======================================================================
// include
#include "FndLiberator.h"

namespace iris {
namespace fnd
{

//======================================================================
// class
/**
 * @brief	I[g|C^NX
 * @details	(@ref section_autoexp_CAutoPtr "autoexp")
 * @tparam	_TN			= Ώی^
 * @tparam	_Liberator	= 폜IuWFNg
*/
template< typename _TN, class _Liberator=CLiberatorObject<_TN> >
class CAutoPtr : public _Liberator
{
	typedef CAutoPtr<_TN, _Liberator>	_Myt;
public:
	typedef _TN		value_type;
	typedef _TN		*value_ptr;
	typedef _TN		&value_ref;
public:
	/// RXgN^
	CAutoPtr(void) : _Liberator(nullptr) 
	{
	}
	/// RXgN^
	explicit CAutoPtr(value_ptr ptr) : _Liberator(ptr) {}
	/// Rs[RXgN^
	CAutoPtr(_Myt& r) : _Liberator(r.release()) {}
	/// fXgN^
	~CAutoPtr(void) { reset(nullptr); }

public:
	//! rebind
	template<typename _TN2> struct rebind { typedef CAutoPtr<_TN2> other; };

public:
	/// 
	_Myt&	operator = (value_ptr ptr)
	{
		reset(ptr);
		return *this;
	}
	/// 
	_Myt&	operator = (_Myt& r)
	{
		reset(r.release());
		return *this;
	}
	/// r
	bool		operator == (value_ptr ptr)	const	{ return this->m_ptr == ptr; }
	/// AhXQ
	value_ref	operator * (void) const			{ return *static_cast<value_ptr>(this->m_ptr); }
	/// A[Zq
	value_ptr	operator -> (void) const		{ return static_cast<value_ptr>(this->m_ptr); }
	/// |C^̎擾
	value_ptr	ptr(void)						{ return static_cast<value_ptr>(this->m_ptr); }
	/// |C^̎擾
	value_ptr	get(void)						{ return static_cast<value_ptr>(this->m_ptr); }
	/// LXg
	operator	value_ptr		(void)			{ return static_cast<value_ptr>(this->m_ptr); }
	operator	const value_ptr	(void)	const	{ return static_cast<value_ptr>(this->m_ptr); }

public:
	/// ֘At̉
	value_ptr	release(void)
	{
		value_ptr p = static_cast<value_ptr>(this->m_ptr);
		this->m_ptr = nullptr;
		return p;
	}
	/// |C^̍Đݒ
	void		reset(value_ptr ptr)
	{
		if( ptr == this->m_ptr ) return;
		_Liberator::liberate();
		this->m_ptr = ptr;
	}
	/// swap
	void		swap(_Myt& b)
	{
		value_ptr p = b.release();
		b = release();
		rest(p);
	}

public:
	/// ^ϊ
	template<typename Other>
	operator CAutoPtr<Other> (void) { return CAutoPtr<Other>(*this); }

	/// 
	template<typename Other>
	_Myt&	operator = (CAutoPtr<Other>& r)
	{
		reset(r.release());
		return *this;
	}
	
	/// RXgN^
	template<typename Other>
	CAutoPtr(CAutoPtr<Other>& r) : _Liberator(r.release()) {}
};

}	// end of namespace fnd
}	// end of namespace iris

#endif

/**
 * @addtogroup	autoexp
 * @{
 * @addtogroup	Visualizer
 * @section		section_autoexp_CAutoPtr	; iris::fnd::CAutoPtr
 * @code
;------------------------------------------------------------------------------
; iris::fnd::CAutoPtr
;------------------------------------------------------------------------------ 
iris::fnd::CAutoPtr<*,*> {
	children
	(
		#(
			[actual members]: [$e,!],
			m_ptr : ($T1*)($e.m_ptr)
		)
	)
	preview
	(
		$e.m_ptr
	)
}
 * @endcode
 * @}
*/