//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndBits.h
 * @brief		rbgϐ t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndBits_H_
#define INCG_IRIS_FndBits_H_

//======================================================================
// include
#include "../../iris_object.h"

namespace iris {
namespace fnd
{

//======================================================================
// class
/// bit ϐ
template<typename _TN>
class CBits : public IIrisObject
{
	typedef CBits<_TN>	_Myt;
	typedef _TN	value_type;
private:
	value_type	m_value;
public:

	/// RXgN^
	CBits(void) : m_value(0) {}
	/// RXgN^
	CBits(value_type val) : m_value(val) {}

public:
	/**
	 * @name operator
	 * @{
	*/
	operator value_type	(void)	{ return m_value; }

public:
	_Myt&	operator	=	(value_type val)	{ m_value = val; return *this; }
	_Myt&	operator	+=	(value_type val)	{ m_value += val; return *this; }
	_Myt&	operator	-=	(value_type val)	{ m_value -= val; return *this; }
	_Myt&	operator	|=	(value_type val)	{ m_value |= val; return *this; }
	_Myt&	operator	&=	(value_type val)	{ m_value &= val; return *this; }
	_Myt&	operator	^=	(value_type val)	{ m_value ^= val; return *this; }
	/**
	 * @}
	*/

public:
	bool	IsBits(value_type val)		const	{ return IRIS_TO_bool(m_value & val); }
	bool	IsEqualBits(value_type val)	const	{ return (m_value & val) == val; }

public:
	void		SetBits(value_type val)				{ m_value = val; }
	value_type	GetBits(void)			const		{ return m_value; }

public:
	void	EnableBits(value_type val)						{ m_value |= val; }
	void	DisableBits(value_type val)						{ m_value &= ~val; }
	void	SetBits(value_type val, bool enable)			{ enable ? EnableBits(val) : DisableBits(val); }
	void	EnableMaskBits(value_type mask, value_type val)	{ DisableBits(mask); EnableBits(mask & val); }
	void	Clear(void)										{ m_value = 0; }
};

//! bittONX
template<u32 BITS=32>
class CBitsFlag : public IIrisObject
{
	enum 
	{
		SIZE	= (BITS+31)/32	//!< zTCY
	};
private:
	u32		m_Flags[SIZE];
public:
	/// RXgN^
	CBitsFlag(void)
	{
		IRIS_STATIC_ASSERT( SIZE > 0 );
		memset(m_Flags, 0, sizeof(m_Flags)); 
	}
	/// fXgN^
	~CBitsFlag(void)	{}

public:
	u32		operator [] (int nIndex) const				{ return GetFlag(nIndex); }

public:
	/// tOON
	CBitsFlag&	EnableFlag(int nOffset)					{ IRIS_FLG32_ON(m_Flags, nOffset); return *this; }
	/// tOON
	CBitsFlag&	EnableFlag(int nIndex, u32 bit)			{ m_Flags[nIndex] |= bit; return *this; }

	/// tOOFF
	CBitsFlag&	DisableFlag(int nOffset)				{ IRIS_FLG32_OFF(m_Flags, nOffset); return *this; }
	/// tOOFF
	CBitsFlag&	DisableFlag(int nIndex, u32 bit)		{ m_Flags[nIndex] &= ~bit; return *this; }

	/// tO`FbN
	bool		IsFlag(int nOffset)			const		{ return (IRIS_FLG32_CK(m_Flags, nOffset) != 0); }
	/// tO`FbN
	bool		IsFlag(int nIndex, u32 bit)	const		{ return ((m_Flags[nIndex] & bit) != 0); }

	/// tOZbg
	CBitsFlag&	SetFlag(int nOffset, bool enable)			{ enable ? EnableFlag(nOffset) : DisableFlag(nOffset); return *this; }
	/// tOZbg
	CBitsFlag&	SetFlag(int nIndex, u32 bit, bool enable)	{ enable ? EnableFlag(nIndex, bit) : DisableFlag(nIndex, bit); return *this; }

	/// tORs[
	void		CopyFlag(int nIndex, u32 flag)			{ m_Flags[nIndex] = flag; }
	/// tONA
	void		ClearFlag(int nIndex)					{ m_Flags[nIndex] = 0; }
	/// tONA
	void		ClearFlag(void)							{ memset(m_Flags, 0, sizeof(m_Flags)); }

	/// tOQ
	u32			GetFlag(int nIndex)		const			{ return m_Flags[nIndex]; }
};

}	// end of namespace fnd
}	// end of namespace iris

#endif
