//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndBuffer.h
 * @brief		obt@NXx[X
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndBuffer_H_
#define INCG_IRIS_FndBuffer_H_

//======================================================================
// include
#include "FndAllocator.h"

namespace iris {
namespace fnd
{

//======================================================================
// class
/**
 * @brief	obt@NX
 * @tparam _TN			= ^
 * @tparam _Allocator	= AP[^
*/
template< typename _TN=u8, typename _Allocator = CNewAllocator<_TN> >
class CBuffer : public INonCopyable<>
{
protected:
	typedef _TN		value_type;
	typedef _TN		*value_ptr;
	typedef _TN		&value_ref;
	typedef typename _Allocator::template rebind<_TN>::other allocator_type;
	typedef CAllocatorInstance<allocator_type>	Allocator;
protected:
	value_ptr	m_pBuffer;	//!< obt@
	u32			m_Size;		//!< obt@TCY
public:
	// RXgN^
	CBuffer(void) : m_pBuffer(nullptr), m_Size(0) {}
	explicit CBuffer(u32 size, s32 arg=0) : m_pBuffer(nullptr), m_Size(0) { alloc(size, arg); }
	//! fXgN^
	virtual	~CBuffer(void)					{ dealloc(); }

public:
	/**
	 * @name operator
	 * @{
	*/
	operator	value_ptr		(void)			{ return ptr(); }
	operator	const value_ptr (void)	const	{ return ptr(); }
	operator	void*			(void)			{ return ptr(); }
	operator	const void*		(void)	const	{ return ptr(); }
	/**
	 * @}
	*/

public:
	/// obt@̊m
	bool	alloc(u32 size, s32 arg=0)
	{
		return resize(size, arg);
	}
	/// TCY
	bool	resize(u32 size, s32 arg=0)
	{
		dealloc();
		m_pBuffer = reinterpret_cast<value_ptr>(Allocator::allocator().alloc(size, arg));
		if( m_pBuffer == nullptr ) return false;
		m_Size = size;
		return true;
	}
	/// obt@̉
	void	dealloc(void)
	{
		Allocator::allocator().dealloc(m_pBuffer);
		m_Size = 0;
		m_pBuffer = nullptr;
	}

public:
	bool	is_valid(void)	const	{ return m_pBuffer != nullptr }
public:
	/**
	 * @name ANZT
	 * @{
	*/
	value_ptr		ptr(void)				{ return m_pBuffer; }	//!< obt@AhX̎擾
	const value_ptr	ptr(void)		const	{ return m_pBuffer; }	//!< obt@AhX̎擾
	u32				length(void)	const	{ return m_Size; }		//!< obt@TCY̎擾
	u32				size(void)		const	{ return m_Size; }		//!< obt@TCY̎擾
	u32				size_of(void)	const	{ return m_Size*sizeof(value_type); }		//!< obt@byteTCY̎擾
	/**
	 * @}
	*/
};

}	// end of namespace fnd
}	// end of namespace iris

#endif
