//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndLinkPtr.h
 * @brief		NXg|C^[ t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndLinkPtr_H_
#define INCG_IRIS_FndLinkPtr_H_

//======================================================================
// include
#include "FndInteractiveList.h"
#include "FndLiberator.h"

namespace iris {
namespace fnd
{

//======================================================================
// class
/**
 * @brief	NXg|C^ǗNX
 *
 * @note	:̃NXɂĊǗĂ|C^́AN悪͉邱Ƃ͂ȂB
 *			܂ANȂƎIɉB
 *			̋ template  liberator ɂĎRɌ߂邱ƂłB
 *
 * @note	:̃NX̊OŁA|C^ꂽꍇ́AǗĂ|C^
 *			^uO|C^ƂȂē삪sɂȂ邽߁Aptr() Ń|C^擾Ă
 *			͂ȂłB
 *
 * @note	:܂Al̗RɂAꏊw|C^ CLinkPtr  ʏ̃|C^ƂŁA
 *			ʂ̊Ǘ@ŊǗ悤Ȏg͂ȂłB
 *			CLinkPtr ŊǗĂ|C^ CLinkPtr ŊǗ悤ɂĂB
 *
 * @tparam	_TN			= Ώی^
 * @tparam	_Liberator	= NX^
 * @tparam	_Allocator	= AP[^^Cv
*/
template< typename _TN, typename _Liberator = CLiberatorObject<_TN> >
class CLinkPtr : public CInteractiveList< CLinkPtr<_TN, _Liberator> >, public _Liberator
{
	typedef CLinkPtr<_TN, _Liberator>	_Myt;
	typedef CInteractiveList<_Myt>		_Mybase;
	typedef _Liberator					Liberator;
public:
	typedef _TN		value_type;
	typedef _TN		*value_ptr;
	typedef _TN		&value_ref;

public:
	/**
	 * @brief	RXgN^
	 * @param [in]	p	= |C^
	*/
	CLinkPtr(value_ptr p=nullptr) : Liberator(p) {}

	/**
	 * @brief	Rs[RXgN^
	*/
	CLinkPtr(_Myt& obj) : Liberator(nullptr)
	{
		if( &obj == this ) return;
		obj.insert(this);
	}

	/**
	 * @brief	fXgN^
	*/
	~CLinkPtr(void)
	{
		unlink();
	}

public:
	bool		is_valid(void)		const	{ return m_ptr != nullptr; }
	bool		is_invalid(void)	const	{ return m_ptr == nullptr; }
	/**
	 * @brief	|C^擾
	 * @return	|C^
	*/
	value_ptr	ptr(void)			const	{ return static_cast<value_ptr>(m_ptr); }

public:
	// operator
	value_ptr	operator ->	(void)				const	{ return ptr(); }
	value_ref	operator *	(void)				const	{ IRIS_ASSERT( m_ptr != nullptr ); return *ptr(); }
				operator value_ptr	(void)		const	{ return ptr(); }

	bool		operator == (const _Myt& src)	const	{ return m_ptr == src.m_ptr(); }
	bool		operator != (const _Myt& src)	const	{ return m_ptr != src.m_ptr(); }

	_Myt&		operator = (const _Myt& src)
	{
		if( &src != this )
		{
			unlink();
			src.insert(this);
		}
		return *this;
	}
	template<typename _TT>
	_Myt&		operator = (const CLinkPtr<_TT, Liberator>& src)
	{
		if( &src != this )
		{
			unlink();
			((cosnt _Myt&)src).insert(this);
		}
		return *this;
	}

private:
	/**
	 * @brief	
	*/
	virtual void	insert(_Myt* const src)
	{
		_Mybase::insert(src);
		src->m_ptr = m_ptr;
	}
	/**
	 * @brief	
	*/
	virtual void	insert_back(_Myt* const src)
	{
		_Mybase::insert_back(src);
		src->m_ptr = m_ptr;
	}
	/**
	 * @brief	
	*/
	virtual void	unlink(void)
	{
		if( !is_link() )
		{
			liberate();	// 폜
		}
		_Mybase::unlink();
		m_ptr = nullptr;
	}
};

}	// end of namespace fnd
}	// end of namespace iris

#endif

/**
 * @section autoexp
 * @code
;------------------------------------------------------------------------------
; iris::fnd::CLinkPtr
;------------------------------------------------------------------------------ 
iris::fnd::CLinkPtr<*,*> {
	children
	(
		#(
			[actual members]: [$e,!],
			m_ptr : ($T1*)($e.m_ptr)
		)
	)
	preview
	(
		$e.m_ptr
	)
}
 * @endcode
*/