//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndList.h
 * @brief		Xgx[XNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndList_H_
#define INCG_IRIS_FndList_H_

//======================================================================
// include
#include "FndTemplateNode.h"
#include "FndIterator.h"
#include "FndOperator.h"
#include "../../iris_debug.h"

namespace iris {
namespace fnd
{

//======================================================================
// declare
class CListNodeBase;
template<typename _TN>class CListNode;
template<typename _TN, class _Liberator>class CListNodeEx;
template<typename _TN>class CList;

//======================================================================
// class

/**
 * @brief	Xgm[hNX
*/
class CListNodeBase : public INonCopyable<CListNodeBase>
{
public:
	CListNodeBase*	m_pPrev;	///< Õm[h
	CListNodeBase*	m_pNext;	///< ̃m[h
public:
	/// RXgN^
	CListNodeBase(void) : m_pPrev(nullptr), m_pNext(nullptr) {}
	/// fXgN^
	virtual	~CListNodeBase(){ unlink(); erase(); }
	/// 폜
	virtual	void	erase(void)	{}
	/// NĂ邩ǂ
	bool			is_link(void)	const	{ return (m_pPrev != nullptr || m_pNext != nullptr); }

	/// N
	void			unlink(void)
	{
		if(m_pPrev != nullptr){ m_pPrev->m_pNext = m_pNext; }
		if(m_pNext != nullptr){ m_pNext->m_pPrev = m_pPrev; }
		m_pPrev = nullptr;
		m_pNext = nullptr;
	}
};

/**
 * @brief  Xgm[hev[g
 * @details	(@ref section_autoexp_CListNode "autoexp")
 * @tparam	_TC	= f[^^
*/
template<typename _TN>
class CListNode : public CTemplateNode<_TN, CListNodeBase>
{
	typedef CTemplateNode<_TN, CListNodeBase>	_Mybase;
public:
	IRIS_PP_USING_MYTYPENAME(value_ptr, _TN*, _Mybase);
	IRIS_PP_USING_MYTYPENAME(value_ref, _TN&, _Mybase);
	IRIS_PP_USING_MYTYPENAME(arg_type , _TN&, _Mybase);
public:
	/// RXgN^
	CListNode(arg_type val) : CTemplateNode<_TN, CListNodeBase>(val) {}
	/// RXgN^
	CListNode(void) {}
	/// fXgN^
	virtual ~CListNode(void) {}
};

/**
 * @brief  Xgm[hev[g
 * @tparam	_TC			= f[^^
 * @tparam	_Liberator	= NX^
*/
template<typename _TN, class _Liberator>
class CListLiberateNode : public CTemplateLiberateNode<_TN, CListNodeBase, _Liberator>
{
	typedef CTemplateLiberateNode<_TN, CListNodeBase, _Liberator>	_Mybase;
public:
	IRIS_PP_USING_MYTYPENAME(value_ptr, _TN*, _Mybase);
	IRIS_PP_USING_MYTYPENAME(value_ref, _TN&, _Mybase);
public:
	/// RXgN^
	explicit CListLiberateNode(value_ptr p) : CTemplateLiberateNode<_TN, CListNodeBase, _Liberator>(p) {}
	/// RXgN^
	CListLiberateNode(void)	{}
	/// fXgN^
	~CListLiberateNode(void) {}
};

//! XgCe[^x[X
class CListIteratorBase : public IIteratorBase<CListNodeBase>
{
public:
	// RXgN^
	CListIteratorBase(void)	{}
	CListIteratorBase(node_ptr node) : IIteratorBase<CListNodeBase>(node) {}
protected:
	/// ̃m[hɐi߂
	void	inc(void)	{ m_pNode = m_pNode->m_pNext; }
	/// Õm[hɖ߂
	void	dec(void)	{ m_pNode = m_pNode->m_pPrev; }
};

/**
 * @brief  Xg
 * @details	(@ref section_autoexp_CList "autoexp")
 * @tparam	_TN	= f[^^
*/
template<typename _TN>
class CList : public INonCopyable<>
{
public:
	typedef	_TN				data_type;
	typedef	_TN*			value_ptr;
	typedef	const _TN*		const_ptr;
	typedef	_TN&			ref;
	typedef	const _TN&		const_ref;
	typedef	CIterator<CListIteratorBase, _TN, _TN&, _TN*>				iterator;
	typedef	CIterator<CListIteratorBase, _TN, const _TN&, const _TN*>	const_iterator;

protected:
	typedef	CListNodeBase	node_type;
	typedef	node_type*		node_ptr;
	typedef	node_type&		node_ref;

private:
	node_type				m_Node;
	node_ptr const			m_pNode;
	s32						m_nSize;

public:
	/// RXgN^
	CList(void)
		: m_pNode(&m_Node)
		, m_nSize(0)
	{ m_Node.m_pPrev = m_Node.m_pNext = &m_Node; }
	/// fXgN^
	virtual	~CList(void){ clear(); }
	
private:
	CList(const CList&) : m_pNode(&m_Node)	{}
	const CList& operator = (const CList&)	{ return *this; }

public:
	iterator		operator [] (int pos)	
	{
		iterator it = begin();
		for( int i=0; i < pos; ++i, ++it ) {}
		return it;
	}
	const_iterator	operator [] (int pos)	const
	{
		const_iterator it = begin();
		for( int i=0; i < pos; ++i, ++it ) {}
		return it;
	}
public:
	/// 擪̃Ce[^擾
	iterator 		begin(void)			{ return static_cast<node_ptr>(m_Node.m_pNext); }
	const_iterator	begin(void) const	{ return static_cast<node_ptr>(m_Node.m_pNext); }
	
	/// I[̃Ce[^擾
	iterator		end(void)			{ return m_pNode; }
	const_iterator	end(void) const		{ return m_pNode; }
	
	/// 擪̃m[h擾
	value_ptr		front(void)			{ return &begin(); }
	const_ptr		front(void) const	{ return &begin(); }
	
	/// I[̃m[h擾
	value_ptr		back(void)			{ return &(--end()); }
	const_ptr		back(void) const	{ return &(--end()); }
	
	/**
	 * @brief ۂǂ
	 * @retval	true	= 
	*/
	bool			empty(void) const	{ return m_Node.m_pNext == &m_Node; }
	
	/**
	 * @brief w͈͂폜
	 * @param [in]	first	= 폜Ce[^̐擪
	 * @param [in]	last	= 폜Ce[^̏I[
	 * @return	폜݂̌̈ʒu
	*/
	iterator		erase(iterator first, iterator last)
	{
		while(first != last) { erase(first++); }
		return last;
	}
	
	/**
	 * @brief 폜
	 * @param [in]	pos	= 폜Ce[^
	*/
	iterator		erase(iterator pos)
	{
		iterator ret = static_cast<CListNodeBase*>(&pos)->m_pNext;
		pos->unlink();
		pos->erase();
		--m_nSize;
		return ret;
	}
	
	/// S폜
	void			clear(void)
	{ 
		erase(begin(), end()); 
	}
	
	/**
	 * @brief }
	 * @param [in]	pos	= }ʒu
	 * @param [in]	val	= }m[h|C^
	*/
	void			insert(iterator pos, value_ptr value)
	{
		CListNodeBase* val = static_cast<CListNodeBase*>(value);
		IRIS_ASSERT( val != nullptr );
		IRIS_ASSERT( val->m_pPrev == nullptr );			// }m[h̑O͖ڑ
		IRIS_ASSERT( val->m_pNext == nullptr );			// }m[h͖̎ڑ
		value_ptr tag = &pos;
		
		val->m_pPrev = tag->m_pPrev;
		val->m_pNext = tag;
		if(tag->m_pPrev != nullptr){
			tag->m_pPrev->m_pNext = val;
		}
		tag->m_pPrev = val;
		++m_nSize;
	}

	/**
	 * @brief 擪ɓo^
	 * @param [in]	val	= o^m[h|C^
	*/
	void			push_front(value_ptr val)	{ insert(begin(), val); }
	
	/// 擪폜
	value_ptr		pop_front(void)				{ value_ptr p=begin(); erase(begin()); return p; }
	
	/**
	 * @brief I[ɓo^
	 * @param [in]	val	= o^m[h|C^
	*/
	void			push_back(value_ptr val)	{ insert(end(), val); }
	
	/// I[擾
	value_ptr		pop_back(void)				{ value_ptr p=back(); erase(back()); return p; }
	
	/**
	 * @brief o^擾
	 * @return	o^
	*/
	s32				size(void)	const
	{
#ifdef _IRIS_DEBUG
		s32 num = 0;
		for( const_iterator ite = begin(), _end=end(); ite != _end; ++ite, ++num ) {}
		IRIS_ASSERT( m_nSize == num );
#endif
		return m_nSize;
	}

public:
	// ȉ̊֐͏RXĝŒӁI

	/**
	 * @brief \[gđ}
	 * @param [in]	val	= }m[h|C^
	*/
	void			sort_insert(value_ptr val)	{ sort_insert(val, CLessOp()); }
	
	/**
	 * @brief \[gđ}
	 * @param [in]	val		= }m[h|C^
	 * @param [in]	func	= r֐IuWFNg
	*/
	template<typename Func>
	void			sort_insert(value_ptr value, const Func& func)
	{
		IRIS_ASSERT( value != nullptr );

		// 납Tđ}
		for( iterator ite = --end(), _end=end(); ite != _end; --ite )
		{
			if( !func(*value, *ite) ) 
			{
				insert(++ite, value);
				return;
			}
		}
		push_front(value);
	}

	/**
	 * @brief SĂiteratorFuncs
	 * @param [in]	func	= s֐IuWFNg
	*/
	template<typename Func>
	void			foreach(Func func)
	{
		for( iterator ite = begin(), _end=end(); ite != _end; ++ite )
			func(*ite);
	}

	/**
	 * @brief 
	 * @param [in]	val		= Ώ
	*/
	iterator		find(const_ref val)	const
	{
		return find(begin(), val, CEqualOp());
	}

	/**
	 * @brief 
	 * @param [in]	val		= Ώ
	 * @param [in]	func	= r֐IuWFNg
	*/
	template<typename Func>
	iterator		find(const_ref val, const Func& func)	const
	{
		return find(begin(), val, func);
	}

	/**
	 * @brief 
	 * @param [in]	pos		= Jnʒu
	 * @param [in]	val		= Ώ
	*/
	iterator		find(const_iterator pos, const_ref val)	const
	{
		return find(pos, val, CEqualOp());
	}

	/**
	 * @brief 
	 * @param [in]	pos		= Jnʒu
	 * @param [in]	val		= Ώ
	 * @param [in]	func	= r֐IuWFNg
	*/
	template<typename Func>
	iterator		find(const_iterator pos, const_ref val, const Func& func)	const
	{
		for( const_iterator it = pos, _end=end(); it != _end; ++it )
		{ 
			if( func(*it, val) ) return iterator(&it);
		}
		return iterator(nullptr);
	}

	/// \[g
	void			sort(void)		{ sort(CLessOp()); }

	/**
	 * @brief \[g
	 * @param [in]	func	= r֐IuWFNg
	*/
	template<typename Func>
	void			sort(const Func& func)	
	{
		merge_sort(size(), begin(), end(), func);
	}

	/**
	 * @brief }[W\[g
	 * @param [in]	num		= m[h
	 * @param [in]	first	= 擪m[h
	 * @param [in]	end		= I[m[h
	 * @param [in]	func	= r֐IuWFNg
	 * @return	V擪m[h
	*/
	template<typename Func>
	iterator		merge_sort(s32 num, iterator first, iterator end, const Func& func)
	{
		s32			half;
		iterator	center, ret;

		if( num <= 1 ) { return first; }
		half = num >> 1;	// / 2;
		num = num - half;
		
		// Xg𔼕ɕ
		center = first;
		for( s32 i = 0; i < num; i++ ){ center++; }

		// Oƌ㔼ꂼ\[g
		first = merge_sort(num, first, center, func);
		center = merge_sort(half, center, end, func);

		// V擪ʒuo
		ret = func(*first, *center) ? first : center;

		// }[W
		while( num > 0 && half > 0 )
		{
			if( func(*first, *center) ) 
			{
				iterator tmp = first->m_pNext;
				erase( first );
				insert( end, &first );
				first = tmp;
				num--;
			} 
			else
			{
				iterator tmp = center->m_pNext;
				erase( center );
				insert( end, &center );
				center = tmp;
				half--;
			}
		}

		while( num > 0 )
		{
			iterator tmp = first->m_pNext;
			erase( first );
			insert( end, &first );
			first = tmp;
			num--;
		}
		while( half > 0 ) 
		{
			iterator tmp = center->m_pNext;
			erase( center );
			insert( end, &center );
			center = tmp;
			half--;
		}
		return ret;
	}
};

}	// end of namespace fnd
}	// end of namespace iris

#endif

/**
 * @addtogroup	autoexp
 * @{
 * @addtogroup	Visualizer
 * @section		section_autoexp_CListNode	; iris::fnd::CListNode
 * @code
;------------------------------------------------------------------------------
; iris::fnd::CListNode
;------------------------------------------------------------------------------
iris::fnd::CListNode<*> {
	children
	(
		#(
			m_value : $e.m_value,
			m_pPrev : (iris::fnd::CListNode<$T1>*)$e.m_pPrev,
			m_pNext : (iris::fnd::CListNode<$T1>*)$e.m_pNext
		)
	)
	preview
	(
		$e.m_value
	)
}
 * @endcode
 * @section		section_autoexp_CList		; iris::fnd::CList
 * @code
;------------------------------------------------------------------------------
; iris::fnd::CList
;------------------------------------------------------------------------------
iris::fnd::CList<*> {
	children
	(
		#(
			#list (
				head : $c.m_Node.m_pNext,
				size : $c.m_nSize,
				next : m_pNext
			),
			#(
				[actual members]: [$e,!]
			)
		)
	)
	preview
	(
		#if($e.m_nSize > 10) 
		(
			#(
				"[", $e.m_nSize, "](",
				#list
				(
					head : $c.m_Node.m_pNext,
					size : 10
					next : m_pNext
				),
				"...)"
			)
		)
		#else
		(
			#(
				"[", $e.m_nSize, "](",
				#list (
					head : $c.m_Node.m_pNext,
					size : $c.m_nSize,
					next : m_pNext
				),
				")"
			)
		)
	)
}
 * @endcode
 * @}
*/
