//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndOperator.h
 * @brief		operatorIuWFNgt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndOperator_H_
#define INCG_IRIS_FndOperator_H_

//======================================================================
// include
#include "../../iris_object.h"

namespace iris {
namespace fnd
{

//======================================================================
// declare
class CFalseOp;		// ɋU
class CTrueOp;		// ɐ^
class CEqualOp;		//  ==
class CLessOp;		// <
class CLEqualOp;	// <=
class CGreaterOp;	// >
class CGEqualOp;	// >=
class CNotEqualOp;	// !=

//======================================================================
// class
// Iy[^IuWFNgʃNX
class COperatorObject : public IIrisObject
{
#ifdef _IRIS_DEBUGTEST_ENABLE
protected:
	mutable s32 m_cnt;	//!< JE^
	void	inc(void) const		{ ++m_cnt; }
public:
	s32		count(void) const	{ return m_cnt; }
#endif

public:
	COperatorObject(void)
#ifdef _IRIS_DEBUGTEST_ENABLE
		: m_cnt(0)
#endif
	{}
};

//! false operator IuWFNg
class CFalseOp : public COperatorObject
{
public:
	template<typename _TN>
	inline bool	operator ()(const _TN& lhs, const _TN& rhs)	const 
	{
		IRIS_UNUSED_VARIABLE(lhs);
		IRIS_UNUSED_VARIABLE(rhs);
#ifdef _IRIS_DEBUGTEST_ENABLE
		inc();
#endif
		return false;
	}

public:
	//! operatorɕʂoperatort
	template<typename _TN>struct append		{ typedef _TN		other; };
	//! operatorperator폜
	template<typename _TN>struct erase		{ typedef CFalseOp	other; };
	//! ΂̐operator
	typedef CTrueOp		opposite;
};

//! true operator IuWFNg
class CTrueOp : public COperatorObject
{
public:
	template<typename _TN>
	inline bool	operator ()(const _TN& lhs, const _TN& rhs)	const 
	{
		IRIS_UNUSED_VARIABLE(lhs);
		IRIS_UNUSED_VARIABLE(rhs);
#ifdef _IRIS_DEBUGTEST_ENABLE
		inc();
#endif
		return true;
	}

private:
	// operatoroperator폜
	template<class _TC, typename _TN>struct erase_impl		{ typedef typename _TN::opposite		other; };
	template<class _TC>struct erase_impl<_TC, _TC>			{ typedef CFalseOp		other; };

public:
	//! operatorɕʂoperatort
	template<typename _TN>struct append		{ typedef _TN		other; };
	//! operatorperator폜
	template<typename _TN>struct erase {
		typedef typename erase_impl<CTrueOp, _TN>::other	other;
	};
	//! ΂̐operator
	typedef CFalseOp	opposite;
};

//! == operator IuWFNg
class CEqualOp : public COperatorObject
{
public:
	template<typename _TN>
	inline bool	operator ()(const _TN& lhs, const _TN& rhs)	const 
	{
#ifdef _IRIS_DEBUGTEST_ENABLE
		inc();
#endif
		return lhs == rhs; 
	}

private:
	// operatorɕʂoperatort
	template<class _TC, typename _TN>struct append_impl		{ typedef _TN		other; };
	template<class _TC>struct append_impl<_TC, CLessOp>		{ typedef CLEqualOp	other; };
	template<class _TC>struct append_impl<_TC, CGreaterOp>	{ typedef CGEqualOp	other; };
	template<class _TC>struct append_impl<_TC, CNotEqualOp>	{ typedef CTrueOp	other; };

	// operatoroperator폜
	template<class _TC, typename _TN>struct erase_impl		{ typedef _TC		other; };
	template<class _TC>struct erase_impl<_TC, _TC>			{ typedef CFalseOp	other; };
	template<class _TC>struct erase_impl<_TC, CGEqualOp>	{ typedef CFalseOp	other; };
	template<class _TC>struct erase_impl<_TC, CLEqualOp>	{ typedef CFalseOp	other; };
	template<class _TC>struct erase_impl<_TC, CTrueOp>		{ typedef CFalseOp	other; };

public:
	//! operatorɕʂoperatort
	template<typename _TN>struct append {
		typedef typename append_impl<CEqualOp, _TN>::other	other;
	};
	//! operatorperator폜
	template<typename _TN>struct erase {
		typedef typename erase_impl<CEqualOp, _TN>::other	other;
	};
	//! ΂̐operator
	typedef CNotEqualOp	opposite;
};

//! < operator IuWFNg
class CLessOp : public COperatorObject
{
public:
	template<typename _TN>
	inline bool	operator ()(const _TN& lhs, const _TN& rhs)	const 
	{
#ifdef _IRIS_DEBUGTEST_ENABLE
		inc();
#endif
		return lhs < rhs; 
	}

private:
	// operatorɕʂoperatort
	template<class _TC, typename _TN>struct append_impl		{ typedef _TN			other; };
	template<class _TC>struct append_impl<_TC, CEqualOp>	{ typedef CLEqualOp		other; };
	template<class _TC>struct append_impl<_TC, CGreaterOp>	{ typedef CNotEqualOp	other; };
	template<class _TC>struct append_impl<_TC, CGEqualOp>	{ typedef CTrueOp		other; };
	template<class _TC>struct append_impl<_TC, CNotEqualOp>	{ typedef _TC			other; };

	// operatoroperator폜
	template<class _TC, typename _TN>struct erase_impl		{ typedef _TC			other; };
	template<class _TC>struct erase_impl<_TC, _TC>			{ typedef CFalseOp		other; };
	template<class _TC>struct erase_impl<_TC, CLEqualOp>	{ typedef CFalseOp		other; };
	template<class _TC>struct erase_impl<_TC, CNotEqualOp>	{ typedef typename append_impl<_TC, CEqualOp>::other	other; };
	template<class _TC>struct erase_impl<_TC, CTrueOp>		{ typedef CFalseOp		other; };

public:
	//! operatorɕʂoperatort
	template<typename _TN>struct append {
		typedef typename append_impl<CLessOp, _TN>::other	other;
	};
	//! operatorperator폜
	template<typename _TN>struct erase {
		typedef typename erase_impl<CLessOp, _TN>::other	other;
	};
	//! ΂̐operator
	typedef CGEqualOp	opposite;
};

//! <= operator IuWFNg
class CLEqualOp : public COperatorObject
{
public:
	template<typename _TN>
	inline bool	operator ()(const _TN& lhs, const _TN& rhs)	const
	{
#ifdef _IRIS_DEBUGTEST_ENABLE
		inc();
#endif
		return lhs <= rhs; 
	}

private:
	// operatorɕʂoperatort
	template<class _TC, typename _TN>struct append_impl		{ typedef _TN			other; };
	template<class _TC>struct append_impl<_TC, CEqualOp>	{ typedef CLEqualOp		other; };
	template<class _TC>struct append_impl<_TC, CLessOp>		{ typedef CLEqualOp		other; };
	template<class _TC>struct append_impl<_TC, CGreaterOp>	{ typedef CTrueOp		other; };
	template<class _TC>struct append_impl<_TC, CGEqualOp>	{ typedef CTrueOp		other; };
	template<class _TC>struct append_impl<_TC, CNotEqualOp>	{ typedef CLessOp		other; };

	// operatoroperator폜
	template<class _TC, typename _TN>struct erase_impl		{ typedef _TC			other; };
	template<class _TC>struct erase_impl<_TC, _TC>			{ typedef CFalseOp		other; };
	template<class _TC>struct erase_impl<_TC, CEqualOp>		{ typedef CLessOp		other; };
	template<class _TC>struct erase_impl<_TC, CLessOp>		{ typedef CEqualOp		other; };
	template<class _TC>struct erase_impl<_TC, CTrueOp>		{ typedef CFalseOp		other; };

public:
	//! operatorɕʂoperatort
	template<typename _TN>struct append {
		typedef typename append_impl<CLEqualOp, _TN>::other	other;
	};
	//! operatorperator폜
	template<typename _TN>struct erase {
		typedef typename erase_impl<CLEqualOp, _TN>::other	other;
	};
	//! ΂̐operator
	typedef CGreaterOp	opposite;
};

//! > operator IuWFNg
class CGreaterOp : public COperatorObject
{
public:
	template<typename _TN>
	inline bool	operator ()(const _TN& lhs, const _TN& rhs)	const 
	{
#ifdef _IRIS_DEBUGTEST_ENABLE
		inc();
#endif
		return lhs > rhs; 
	}

private:
	// operatorɕʂoperatort
	template<class _TC, typename _TN>struct append_impl		{ typedef _TN			other; };
	template<class _TC>struct append_impl<_TC, CEqualOp>	{ typedef CGEqualOp		other; };
	template<class _TC>struct append_impl<_TC, CLessOp>		{ typedef CNotEqualOp	other; };
	template<class _TC>struct append_impl<_TC, CLEqualOp>	{ typedef CTrueOp		other; };
	template<class _TC>struct append_impl<_TC, CNotEqualOp>	{ typedef CGreaterOp	other; };

	// operatoroperator폜
	template<class _TC, typename _TN>struct erase_impl		{ typedef _TC			other; };
	template<class _TC>struct erase_impl<_TC, _TC>			{ typedef CFalseOp		other; };
	template<class _TC>struct erase_impl<_TC, CGEqualOp>	{ typedef CFalseOp		other; };
	template<class _TC>struct erase_impl<_TC, CNotEqualOp>	{ typedef typename append_impl<_TC, CEqualOp>::other	other; };
	template<class _TC>struct erase_impl<_TC, CTrueOp>		{ typedef CFalseOp		other; };

public:
	//! operatorɕʂoperatort
	template<typename _TN>struct append {
		typedef typename append_impl<CGreaterOp, _TN>::other	other;
	};
	//! operatorperator폜
	template<typename _TN>struct erase {
		typedef typename erase_impl<CGreaterOp, _TN>::other	other;
	};
	//! ΂̐operator
	typedef CLEqualOp	opposite;
};

//! >= operator IuWFNg
class CGEqualOp : public COperatorObject
{
public:
	template<typename _TN>
	inline bool	operator ()(const _TN& lhs, const _TN& rhs)	const
	{
#ifdef _IRIS_DEBUGTEST_ENABLE
		inc();
#endif
		return lhs >= rhs; 
	}

private:
	// operatorɕʂoperatort
	template<class _TC, typename _TN>struct append_impl		{ typedef _TN			other; };
	template<class _TC>struct append_impl<_TC, CEqualOp>	{ typedef CGEqualOp		other; };
	template<class _TC>struct append_impl<_TC, CLessOp>		{ typedef CTrueOp		other; };
	template<class _TC>struct append_impl<_TC, CLEqualOp>	{ typedef CTrueOp		other; };
	template<class _TC>struct append_impl<_TC, CGreaterOp>	{ typedef CGEqualOp		other; };
	template<class _TC>struct append_impl<_TC, CNotEqualOp>	{ typedef CGreaterOp	other; };

	// operatoroperator폜
	template<class _TC, typename _TN>struct erase_impl		{ typedef _TC			other; };
	template<class _TC>struct erase_impl<_TC, _TC>			{ typedef CFalseOp		other; };
	template<class _TC>struct erase_impl<_TC, CEqualOp>		{ typedef CGreaterOp	other; };
	template<class _TC>struct erase_impl<_TC, CGreaterOp>	{ typedef CEqualOp		other; };
	template<class _TC>struct erase_impl<_TC, CTrueOp>		{ typedef CFalseOp		other; };

public:
	//! operatorɕʂoperatort
	template<typename _TN>struct append {
		typedef typename append_impl<CGEqualOp, _TN>::other	other;
	};
	//! operatorperator폜
	template<typename _TN>struct erase {
		typedef typename erase_impl<CGEqualOp, _TN>::other	other;
	};
	//! ΂̐operator
	typedef CLessOp	opposite;
};

//! != operator IuWFNg
class CNotEqualOp : public COperatorObject
{
public:
	template<typename _TN>
	inline bool	operator ()(const _TN& lhs, const _TN& rhs)	const
	{
#ifdef _IRIS_DEBUGTEST_ENABLE
		inc();
#endif
		return lhs != rhs;
	}

private:
	// operatorɕʂoperatort
	template<class _TC, typename _TN>struct append_impl		{ typedef _TN			other; };
	template<class _TC>struct append_impl<_TC, CEqualOp>	{ typedef CTrueOp		other; };
	template<class _TC>struct append_impl<_TC, CGEqualOp>	{ typedef CGreaterOp	other; };
	template<class _TC>struct append_impl<_TC, CLEqualOp>	{ typedef CLessOp		other; };

	// operatoroperator폜
	template<class _TC, typename _TN>struct erase_impl		{ typedef _TC			other; };
	template<class _TC>struct erase_impl<_TC, _TC>			{ typedef CFalseOp		other; };
	template<class _TC>struct erase_impl<_TC, CTrueOp>		{ typedef CFalseOp		other; };

public:
	//! operatorɕʂoperatort
	template<typename _TN>struct append {
		typedef typename append_impl<CNotEqualOp, _TN>::other	other;
	};
	//! operatorperator폜
	template<typename _TN>struct erase {
		typedef typename erase_impl<CNotEqualOp, _TN>::other	other;
	};
	//! ΂̐operator
	typedef CEqualOp	opposite;
};

}	// end of namespace fnd
}	// end of namespace iris

#endif
