//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndOrderedTree.h
 * @brief		c[NXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndOrderedTree_H_
#define INCG_IRIS_FndOrderedTree_H_

//======================================================================
// include
#include "FndIterator.h"
#include "../../iris_debug.h"

namespace iris {
namespace fnd
{

//======================================================================
// declare
class COrderedTreeNodeBase;
template<typename _TN>class COrderedTreeNode;
template<class _TC>class COrderedTree;

//======================================================================
// class
//! ؃m[hNXx[X
class COrderedTreeNodeBase : public INonCopyable<>
{
public:
	typedef COrderedTreeNodeBase	node;
	typedef COrderedTreeNodeBase	*node_ptr;
	typedef COrderedTreeNodeBase	&node_ref;

private:
	node_ptr	m_pParent;	//!< e
	node_ptr	m_pChild;	//!< q
	node_ptr	m_pBrother;	//!< Z
public:
	/// RXgN^
	COrderedTreeNodeBase(void) : m_pParent(nullptr), m_pChild(nullptr), m_pBrother(nullptr) {}
	/// fXgN^
	virtual ~COrderedTreeNodeBase(void)	{ unlink(); }

public:
	/// 폜
	virtual void	erase(void)	{}
	/// N̉
	virtual void	unlink(void)
	{
		// eƌZƂ̉؂
		if( m_pParent != nullptr )
		{
			node_ptr p = m_pParent->m_pChild;
			node_ptr *pp = nullptr;
			if( p == this )
			{
				pp = &m_pParent->m_pChild;
			}
			else
			{
				while( p->m_pBrother != this )
				{
					p = p->m_pBrother;
					IRIS_ASSERT( p != nullptr );
				}
				pp = &p->m_pBrother;
			}

			if( m_pChild == nullptr )
			{
				*pp = m_pBrother;
			}
			else
			{
				*pp = m_pChild;
				p = m_pChild;
				while( p->m_pBrother != nullptr )
				{
					p = p->m_pBrother;
				}
				p->m_pBrother = m_pBrother;
			}
		}
		m_pParent	= nullptr;
		m_pBrother	= nullptr;
		m_pChild	= nullptr;

		erase();
	}

public:
	/// qǉ
	void		push_child(node_ptr ptr)
	{
		IRIS_ASSERT( ptr != nullptr );
		IRIS_ASSERT( ptr->m_pParent == nullptr );
		if( m_pChild == nullptr ) m_pChild = ptr;
		else
		{
			node_ptr p = m_pChild;
			while( p->m_pBrother != nullptr )
			{
				p = p->m_pBrother;
			}
			p->m_pBrother = ptr;
		}
		ptr->m_pParent  = this;
	}

	/// ǉ
	void		push_brother(node_ptr ptr)
	{
		IRIS_ASSERT( ptr != nullptr );
		IRIS_ASSERT( ptr->m_pParent == nullptr );
		if( m_pBrother == nullptr ) m_pBrother = ptr;
		else
		{
			node_ptr p = m_pBrother;
			while( p->m_pBrother != nullptr )
			{
				p = p->m_pBrother;
			}
			p->m_pBrother = ptr;
		}
		ptr->m_pParent  = this;
	}

public:
	/// q}
	void		insert_child(node_ptr ptr)
	{
		IRIS_ASSERT( ptr );
		IRIS_ASSERT( ptr->m_pParent == nullptr );
		IRIS_ASSERT( ptr->m_pChild == nullptr );
		IRIS_ASSERT( ptr->m_pBrother == nullptr );
		if( m_pParent != nullptr )
		{
			node_ptr p = m_pParent->m_pChild;
			if( p == this ) m_pParent->m_pChild = ptr;
			else
			{
				while( p->m_pBrother != this )
				{
					p = p->m_pBrother;
					IRIS_ASSERT(p != nullptr);
				}
				p->m_pBrother = ptr;
			}
		}
		ptr->m_pParent	= m_pParent;
		ptr->m_pBrother = m_pBrother;
		ptr->m_pChild	= this;
		m_pParent	= ptr;
		node_ptr b = m_pBrother;
		while( b != nullptr )
		{
			b->m_pParent = ptr;
			b = b->m_pBrother;
		}
	}

	/// q}
	void		insert_brother(node_ptr ptr)
	{
		IRIS_ASSERT( ptr );
		IRIS_ASSERT( ptr->m_pParent == nullptr );
		IRIS_ASSERT( ptr->m_pBrother == nullptr );
		if( m_pParent != nullptr )
		{
			node_ptr p = m_pParent->m_pChild;
			if( p == this ) m_pParent->m_pChild = ptr;
			else
			{
				while( p->m_pBrother != this )
				{
					p = p->m_pBrother;
					IRIS_ASSERT(p != nullptr);
				}
				p->m_pBrother = ptr;
			}
		}
		ptr->m_pParent	= m_pParent;
		ptr->m_pBrother = this;
	}

public:
	/// ̃m[h擾
	node_ptr	next(void)
	{
		if( m_pChild != nullptr ) return m_pChild;
		if( m_pBrother != nullptr ) return m_pBrother;
		node_ptr p = m_pParent;
		while(p != nullptr)
		{
			node_ptr tmp = p->m_pBrother;
			if( tmp != nullptr ) return tmp;
			p = p->parent();
		}
		return nullptr;
	}
public:
	/// e̎擾
	node_ptr	parent(void)	const	{ return m_pParent; }
	/// q̎擾
	node_ptr	child(void)		const	{ return m_pChild; }
	/// Z̎擾
	node_ptr	brother(void)	const	{ return m_pBrother; }
};

//! ؃m[hNX
template<typename _TN>
class COrderedTreeNode : public COrderedTreeNodeBase
{
public:
	typedef	_TN		data_type;
	typedef	_TN*	data_ptr;
	typedef	_TN&	data_ref;
private:
	data_ptr	m_ptr;
public:
	/// RXgN^
	COrderedTreeNode(data_ptr p) : m_ptr(p) {}

	// Iy[^
	data_ref		operator *	() const	{ return *m_ptr; }
	data_ptr		operator -> () const	{ return m_ptr; }

	s32				operator == (const COrderedTreeNode<data_type>& rhs) const	{ return *this->m_ptr == *rhs; }
	s32				operator != (const COrderedTreeNode<data_type>& rhs) const	{ return *this->m_ptr != *rhs; }
	s32				operator <  (const COrderedTreeNode<data_type>& rhs) const	{ return *this->m_ptr < *rhs; }
	s32				operator <= (const COrderedTreeNode<data_type>& rhs) const	{ return *this->m_ptr <= *rhs; }
	s32				operator >  (const COrderedTreeNode<data_type>& rhs) const	{ return *this->m_ptr > *rhs; }
	s32				operator >= (const COrderedTreeNode<data_type>& rhs) const	{ return *this->m_ptr >= *rhs; }

	/// |C^擾
	data_ptr		ptr(void) const			{ return m_ptr; }
};

//! ؃Ce[^x[X
class COrderedTreeIteratorBase : public IIteratorBase<COrderedTreeNodeBase>
{
	typedef IIteratorBase<COrderedTreeNodeBase>	Base;
protected:
	using Base::node_ptr;
public:
	// RXgN^
	COrderedTreeIteratorBase(void)	{}
	COrderedTreeIteratorBase(node_ptr node) : Base(node) {}
protected:
	/// ̃m[hɐi߂
	void	inc(void)	{ m_pNode = m_pNode->next(); }
	/// Õm[hɖ߂
	void	dec(void)	{ IRIS_ASSERT(0); }
};


//! ؃NX
template<class _TC>
class COrderedTree : public INonCopyable<>
{
public:
	typedef _TC						data_type;
	typedef _TC						*data_ptr;
	typedef _TC						&data_ref;
	typedef	CIterator<COrderedTreeIteratorBase, _TC, _TC&, _TC*>				iterator;
	typedef	CIterator<COrderedTreeIteratorBase, _TC, const _TC&, const _TC*>	const_iterator;
protected:
	typedef COrderedTreeNodeBase	node_type;
	typedef node_type				*node_ptr;
	typedef node_type				&node_ref;
private:
	node_type						m_root;	//!< [g

public:
	/// RXgN^
	COrderedTree(void)	{}
	/// fXgN^
	~COrderedTree(void)	{ clear(); }

public:
	/// 󂩂ǂ
	bool		empty(void)		const	{ return m_root.child() == nullptr; }

	/// NA
	void		clear(void)
	{
		erase(begin(), end());
	}

public:
	/// 擪̃Ce[^擾
	iterator 		begin(void)			{ return static_cast<node_ptr>(m_root.child()); }
	const_iterator	begin(void) const	{ return static_cast<node_ptr>(m_root.child()); }
	/// I[̃Ce[^擾
	iterator		end(void)			{ return (node_ptr)nullptr; }
	const_iterator	end(void)	const	{ return (node_ptr)nullptr; }

public:
	/// 폜
	iterator		erase(iterator first, iterator last)
	{
		while(first != last)
		{
			erase(first++);
		}
		return last;
	}
	/// 폜
	iterator		erase(iterator pos)
	{
		iterator ret = pos->next();
		pos->unlink();
		pos->erase();
		return ret;
	}

public:
	/// qǉ
	void		push_child(data_ptr ptr)		{ push_child(&m_root, ptr); }
	/// ǉ
	void		push_brother(data_ptr ptr)		{ push_brother(&m_root, ptr); }
	/// q}
	void		insert_child(data_ptr ptr)		{ insert_child(&m_root, ptr); }
	/// }
	void		insert_brother(data_ptr ptr)	{ insert_brother(&m_root, ptr); }

	/// qǉ
	void		push_child(iterator pos, data_ptr ptr)		{ pos->push_child(ptr); }
	/// ǉ
	void		push_brother(iterator pos, data_ptr ptr)	{ pos->push_brother(ptr); }
	/// q}
	void		insert_child(iterator pos, data_ptr ptr)	{ pos->insert_child(ptr); }
	/// }
	void		insert_brother(iterator pos, data_ptr ptr)	{ pos->insert_brother(ptr); }
};

}	// end of namespace fnd
}	// end of namespace iris

#endif
