//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndRange.h
 * @brief		͈̓IuWFNgNX t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndRange_H_
#define INCG_IRIS_FndRange_H_

//======================================================================
// include
IRIS_PRAGMA_WARNING_BEGIN()
IRIS_PRAGMA_WARNING_DISABLE(4700)

#include "FndZero.h"
#include "../../ml/iml_type_select.hpp"
#include "../../ml/iml_op.hpp"
#include "../../c++0x/cpp0x_type_traits.hpp"
#include "../../iris_debug.h"

IRIS_PRAGMA_WARNING_END()

namespace iris {
namespace fnd
{

//======================================================================
// class
/**
 * @brief	͈̓NX
 * @tparam	͈͂̐擪EI[̕\^
*/
template<typename _TN>
class CRange : public IIrisObject
{
	typedef CRange<_TN>	_Myt;
public:
	typedef	_TN			value_type;
	typedef _TN			*value_ptr;
	typedef _TN			&value_ref;
	typedef const _TN	&const_ref;

private:
	value_type	m_begin;	//!< ͈͂̐擪
	value_type	m_end;		//!< ͈͂̏I[
public:
	/**
	 * @brief	RXgN^
	*/
	CRange(void)
		: m_begin(CZero<value_type>::get())
		, m_end(CZero<value_type>::get())
	{
	}

	/**
	 * @brief	RXgN^
	*/
	CRange(const_ref begin)
		: m_begin(begin)
		, m_end(begin+1)
	{
		IRIS_ASSERT( m_begin <= m_end );
	}

	/**
	 * @brief	RXgN^
	*/
	CRange(const_ref begin, const_ref end)
		: m_begin(begin)
		, m_end(end)
	{
		IRIS_ASSERT( m_begin <= m_end );
		if( m_begin > m_end )
		{
			swap(m_begin, m_end);
		}
	}

public:
	// get, set
	value_ref	begin(void)			{ return m_begin; }
	value_ref	end(void)			{ return m_end; }
	value_type	size(void)	const	{ return m_end - m_begin; }

public:

	// operator

	bool	operator <  (const _Myt& rhs)	const	{ return m_end < rhs.m_begin; }
	bool	operator >  (const _Myt& rhs)	const	{ return m_begin > rhs.m_end; }
	bool	operator <= (const _Myt& rhs)	const	{ return m_begin <= rhs.m_end; }
	bool	operator >= (const _Myt& rhs)	const	{ return m_end >= rhs.m_begin; }

	// Sv
	bool	operator == (const _Myt& rhs)	const	{ return (m_begin == rhs.m_begin) && (m_end == rhs.m_end); }
	bool	operator != (const _Myt& rhs)	const	{ return (m_begin != rhs.m_begin) || (m_end != rhs.m_end); }

	// dv́ArIy[^ŔrIɎ\

};

#if	defined(IRIS_MFC_VER)
/**
 * @brief	MFC pnbV擾֐
*/
template<class ARGKEY, typename _TN>
AFX_INLINE UINT AFXAPI HashKey(CRange<_TN> key)
{
	return (UINT)key.begin();	// TODO : Ƃ肠
}
#endif

}	// end of namespace fnd
}	// end of namespace iris

#endif
