//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndRedBlackTree.h
 * @brief		ԍ؃NXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndRedBlackTree_H_
#define INCG_IRIS_FndRedBlackTree_H_

//======================================================================
// include
#include "FndBinarySearchTree.h"
#include "../../iris_debug.h"

namespace iris {
namespace fnd
{

//======================================================================
// define
// null_node m[h݂邩ǂ
#define	EXIST_REDBLACKTREE_NIL	1

//======================================================================
// declare
class CRBTreeNodeBase;
template<typename _TN>class CRBTreeNode;
template<typename _TN, class _Liberator>class CRBTreeLiberateNode;
template<class _TC>class CRBTree;

//======================================================================
// class
/**
 * @brief	ԍ؃m[hx[XNX
*/
class CRBTreeNodeBase : public IBSTreeNodeBase<CRBTreeNodeBase>
{
public:
	//! m[h̐F
	typedef enum
	{
		BLACK	= 'B',	//!< 
		RED		= 'R',	//!< 
		UNKNOWN	= 'X'	//!< s
	} COLOR;
public:
	s8			m_Color;	//!< F

public:
	/// RXgN^
	CRBTreeNodeBase(void)
		: m_Color(BLACK) {}

	/// 폜̏
	virtual	void		erase(void)	{}
	/// N̉
	virtual void		unlink(void)
	{
		m_pParent = nullptr;
		m_pLeft = null_node();
		m_pRight = null_node();
	}

private:
	/// RXgN^(null_nodep)
	explicit CRBTreeNodeBase(s8 /*dummy*/) 
		: m_Color(BLACK) { m_pLeft = nullptr; m_pRight = nullptr; m_pParent = nullptr; }
public:
	/**
	 * @brief	null_nodeIuWFNg̎擾
	 * @return	null_nodeIuWFNg
	*/
	inline static	node_ptr		null_node(void)
	{
#if EXIST_REDBLACKTREE_NIL
		static node_type s_null_node(0);
		return &s_null_node;
#else
		return nullptr;
#endif
	}
};

/**
 * @brief	ԍ؃m[hNXx[X
 * @details	(@ref section_autoexp_CRBTreeNode "autoexp")
 * @tparam	_TN	= Ώی^
*/
template<typename _TN>
class CRBTreeNode : public CTemplateNode<_TN, CRBTreeNodeBase>
{
	typedef CTemplateNode<_TN, CRBTreeNodeBase>	_Mybase;
public:
	IRIS_PP_USING_MYTYPENAME(value_ptr, _TN*, _Mybase);
	IRIS_PP_USING_MYTYPENAME(arg_type , _TN&, _Mybase);
public:
	/// RXgN^
	CRBTreeNode(arg_type val) : CTemplateNode<_TN, CRBTreeNodeBase>(val) {}
	/// RXgN^
	CRBTreeNode(void) {}
	/// fXgN^
	~CRBTreeNode(void) {}
};

/**
 * @brief	ԍ؃m[hNXx[X
 * @tparam	_TN			= Ώی^
 * @tparam	_Liberator	= NX^
*/
template< typename _TN, class _Liberator=CLiberatorObject<_TN> >
class CRBTreeLiberateNode : public CTemplateLiberateNode<_TN, CRBTreeNodeBase, _Liberator>
{
	typedef CTemplateLiberateNode<_TN, CRBTreeNodeBase, _Liberator>	_Mybase;
public:
	IRIS_PP_USING_MYTYPENAME(value_ptr, _TN*, _Mybase);
public:
	/// RXgN^
	CRBTreeLiberateNode(value_ptr p) : CTemplateLiberateNode<_TN, CRBTreeNodeBase, _Liberator>(p) {}
	/// RXgN^
	CRBTreeLiberateNode(void) {}
	/// fXgN^
	~CRBTreeLiberateNode(void) {}
};

/**
 * @brief	ԍ؃NX
 * @details	(@ref section_autoexp_CRBTree "autoexp")
 *
 * @note	terms 1 : m[h͐Ԃł
 *			terms 2 : ͍ł
 *			terms 3 : SĂ̗t͍ł
 *			terms 4 : Ԃm[h̎q͍ł
 *			terms 5 : SĂ̗t獪܂ł̃pXɂ́A̍m[h
 *
 * @tparam	_TC	= Ώی^
*/
template<class _TC>
class CRBTree : public IBSTree<_TC, CRBTreeNodeBase>
{
	typedef IBSTree<_TC, CRBTreeNodeBase> _Mybase;
public:
	IRIS_PP_USING_MYTYPENAME(value_ptr, _TC*			, _Mybase);
	IRIS_PP_USING_MYTYPENAME(node_type, CRBTreeNodeBase	, _Mybase);
	IRIS_PP_USING_MYTYPENAME(node_ptr , CRBTreeNodeBase*, _Mybase);
public:
	/// RXgN^
	CRBTree(void) {}

protected:
	/**
	 * @brief	m[h̓ւ
	 * @return	ւ̃[gm[h
	*/
	value_ptr		swap(value_ptr n1, value_ptr n2)
	{
		s8 tmp = n1->m_Color;
		n1->m_Color = n2->m_Color; 
		n2->m_Color = tmp; 
		return _Mybase::swap(n1, n2);
	}
private:
	/**
	 * @brief	m[h̒ǉ
	 * @param [in]	ptr	= ǉm[h
	 * @return	ǉ̃[gm[h
	*/
	virtual value_ptr		insert_internal(value_ptr ptr)
	{
		ptr->m_Color = node_type::RED;	// ǉƂ͐
		return _Mybase::insert_internal(ptr);
	}

private:
	/**
	 * @brief	c[]ăoX𐮂(m[h̒ǉ)
	 * @param [in]	node	= ǉsm[h̐e
	 * @param [in]	key		= ǉsm[h̃L[
	 * @return	]̃[gm[h
	*/
	virtual	value_ptr		rotate_tree_add(value_ptr node, value_ptr key)
	{
		if(this->m_root == nullptr) return nullptr;
		IRIS_ASSERT(key != nullptr && key->m_Color == node_type::RED);
		if(this->m_root == key)
		{
			// ̏ꍇ͍
			key->m_Color = node_type::BLACK;
			return this->m_root;
		}

		// e
		if( node->m_Color == node_type::RED )
		{
			// c
			value_ptr grand = static_cast<value_ptr>(node->m_pParent);
			// e̐eȂꍇ
			if( grand == nullptr )
			{
				// ɂȂ
				node->m_Color = node_type::BLACK;
			}
			else
			{
				// f𒲂ׂ
				value_ptr uncle = static_cast<value_ptr>( grand->m_pLeft == node ? grand->m_pRight : grand->m_pLeft );
				if( !this->is_null_node(uncle) )
				{
					// fԂ̏ꍇ
					if( uncle->m_Color == node_type::RED )
					{
						// eƏfɂ
						node->m_Color = uncle->m_Color = node_type::BLACK;
						// cԂɂ
						grand->m_Color = node_type::RED;
						// cǉ̂ƂčċAIɏ
						return rotate_tree_add(static_cast<value_ptr>(grand->m_pParent), grand);
					}
				}
				// f̏ꍇ

				// e̍ɒǉꂽꍇ
				if( node->m_pLeft == key )
				{
					// ɂꍇ
					if( grand->m_pRight == node )
					{
						// E1]
						this->m_root = this->rotate_right1(key);
						// 1]
						this->m_root = this->rotate_left1(key);
						key->m_Color = node_type::BLACK;
						grand->m_Color = node_type::RED;
					}
					else
					{
						// E1]
						this->m_root = this->rotate_right1(node);
						node->m_Color = node_type::BLACK;
						grand->m_Color = node_type::RED;
					}
				}
				// ẻEɒǉꂽꍇ
				else
				{
					// ɂꍇ
					if( grand->m_pLeft == node )
					{
						// 1]
						this->m_root = this->rotate_left1(key);
						// E1]
						this->m_root = this->rotate_right1(key);
						key->m_Color = node_type::BLACK;
						grand->m_Color = node_type::RED;
					}
					else
					{
						// 1]
						this->m_root = this->rotate_left1(node);
						node->m_Color = node_type::BLACK;
						grand->m_Color = node_type::RED;
					}
				}
			}
		}
		// e
		//else if( node->m_Color == node_type::BLACK )
		//{
		//	// Ԃ}Ă͕Ȃ̂OK
		//	return this->m_root;
		//}
		return this->m_root;
	}

	/**
	 * @brief	c[]ăoX𐮂(m[h̍폜)
	 * @param [in]	parent	= 폜sm[h̐e
	 * @param [in]	key		= 폜sm[h̃L[
	 * @param [in]	swapkey	= 폜ɌL[
	 * @return	]̃[gm[h
	*/
	virtual	value_ptr		rotate_tree_sub(value_ptr parent, value_ptr key, node_ptr swapkey)
	{
		// 폜m[h̏ꍇ
		if( key->m_Color == node_type::BLACK )
		{
			while(1)
			{
				if( parent == nullptr )
				{
					// Ȃ̂ŋIɍ
					swapkey->m_Color = node_type::BLACK;
#ifdef _IRIS_DEBUGTEST_ENABLE
					check_tree_root();
#endif
					break;
				}

				// m[hԂ̏ꍇ
				if( swapkey->m_Color == node_type::RED )
				{
					swapkey->m_Color = node_type::BLACK;
#ifdef _IRIS_DEBUGTEST_ENABLE
					check_tree_root();
#endif
					break;
				}

				// m[h̏ꍇ
				value_ptr bro = nullptr;
				// 폜ꂽꍇ
				if( parent->m_pLeft == swapkey )
				{
					bro = static_cast<value_ptr>(parent->m_pRight);
					// Z킪
					if( bro->m_Color == node_type::RED )
					{
						// 1]
						this->rotate_left1(bro);
						parent->m_Color = node_type::RED;
						bro->m_Color = node_type::BLACK;
						bro = static_cast<value_ptr>(parent->m_pRight);
						if( this->is_null_node(bro) ) break;
					}

					// Z̋߂̎q
					// Z̉̎q
					value_ptr nephew = static_cast<value_ptr>(bro->m_pLeft);
					value_ptr nephew2 = static_cast<value_ptr>(bro->m_pRight);
					IRIS_ASSERT( nephew != nullptr );
					IRIS_ASSERT( nephew2 != nullptr );
					if( nephew->m_Color == node_type::RED && nephew2->m_Color == node_type::BLACK )
					{
						// E1]
						this->rotate_right1(nephew);
						bro->m_Color = node_type::RED;
						nephew->m_Color = node_type::BLACK;
						nephew2 = bro;
						bro = nephew;
						IRIS_ASSERT( bro->m_pRight->m_Color == node_type::RED );
					}

					// Z̉̎q
					if( nephew2->m_Color == node_type::RED )
					{
						// 1]
						this->rotate_left1(bro);
						bro->m_Color = parent->m_Color;
						parent->m_Color = nephew2->m_Color = node_type::BLACK;
#ifdef _IRIS_DEBUGTEST_ENABLE
						check_tree_root();
#endif
						break;
					}

					// Z̎qƂ
					bro->m_Color = node_type::RED;
					// e
					if( parent->m_Color == node_type::RED )
					{
						parent->m_Color = node_type::BLACK;
#ifdef _IRIS_DEBUGTEST_ENABLE
						check_tree_root();
#endif
						break;
					}
					parent->m_Color = node_type::BLACK;
					swapkey = parent;
					parent = static_cast<value_ptr>(swapkey->m_pParent);
				}
				else
				{
					IRIS_ASSERT( parent->m_pRight == swapkey );
					// Z킪
					bro = static_cast<value_ptr>(parent->m_pLeft);
					if( bro->m_Color == node_type::RED )
					{
						// E1]
						this->rotate_right1(bro);
						parent->m_Color = node_type::RED;
						bro->m_Color = node_type::BLACK;
						bro = static_cast<value_ptr>(parent->m_pLeft);
						if( this->is_null_node(bro) ) break;
					}

					// Z̉̎q
					// Z̋߂̎q
					value_ptr nephew = static_cast<value_ptr>(bro->m_pRight);
					value_ptr nephew2 = static_cast<value_ptr>(bro->m_pLeft);
					IRIS_ASSERT( nephew != nullptr );
					IRIS_ASSERT( nephew2 != nullptr );
					if( nephew->m_Color == node_type::RED && nephew2->m_Color == node_type::BLACK )
					{
						// 1]
						this->rotate_left1(nephew);
						bro->m_Color = node_type::RED;
						nephew->m_Color = node_type::BLACK;
						nephew2 = bro;
						bro = nephew;
						IRIS_ASSERT( bro->m_pLeft->m_Color == node_type::RED );
					}

					// Z̉̎q
					if( nephew2->m_Color == node_type::RED )
					{
						// E1]
						this->rotate_right1(bro);
						bro->m_Color = parent->m_Color;
						parent->m_Color = nephew2->m_Color = node_type::BLACK;
#ifdef _IRIS_DEBUGTEST_ENABLE
						check_tree_root();
#endif
						break;
					}

					// Z̎qƂ
					bro->m_Color = node_type::RED;
					// e
					if( parent->m_Color == node_type::RED )
					{
						parent->m_Color = node_type::BLACK;
#ifdef _IRIS_DEBUGTEST_ENABLE
						check_tree_root();
#endif
						break;
					}
					parent->m_Color = node_type::BLACK;
					swapkey = parent;
					parent = static_cast<value_ptr>(swapkey->m_pParent);
				}
			}
		}
		return this->m_root;
	}

#ifndef _IRIS_DEBUG
public:
	void	print(void)	const	{}
#else
public:
	/// Wo͂ɏo
	void	print(void)	const
	{
		value_ptr	next = this->m_root;
		s32			indent = 0;
		if(next == nullptr)	return;
		while(1)
		{
			int i;
			for(i = 0; i < indent; i++) 
			{
				printf(" ");
			}
			printf("key:0x%08x ", (u32)(u32w64)next);
			printf("l:");
			if( !this->is_null_node(next->m_pLeft) )
			{
				IRIS_ASSERT( next->m_pLeft->m_pParent == next );
				printf("0x%08x ", (u32)(u32w64)next->m_pLeft);
			}
			else							printf("- ");

			printf("r:");
			if( !this->is_null_node(next->m_pRight) )
			{
				IRIS_ASSERT( next->m_pRight->m_pParent == next );
				printf("0x%08x ", (u32)(u32w64)next->m_pRight);
			}
			else							printf("- ");
			printf("c:%c x:%x\n", next->m_Color, (u32)(u32w64)next);
			
			if( !this->is_null_node(next->m_pLeft) )
			{
				indent++;
				next = static_cast<value_ptr>(next->m_pLeft);
			}
			else if( !this->is_null_node(next->m_pRight) )
			{
				indent++;
				next = static_cast<value_ptr>(next->m_pRight);
			}
			else 
			{
				value_ptr parent;
				while(1)
				{
					parent = static_cast<value_ptr>(next->m_pParent);
					if(parent == nullptr) return;
					indent--;
					if(parent->m_pRight == next) 
					{
						next = parent;
					}
					else 
					{
						next = parent;
						if( !this->is_null_node(next->m_pRight) )
						{
							next = static_cast<value_ptr>(next->m_pRight);
							indent++;
							break;
						}
					}
				}
			}
		}
	}
#endif

#ifdef _IRIS_DEBUGTEST_ENABLE
	/// m[h̐
	virtual void	check_node(value_ptr node)	const
	{
		if( node == nullptr ) return;
		_Mybase::check_node(node);

		if( node->m_pParent != nullptr )
		{
			// ǂ̎q̂͂
			IRIS_ASSERT(node->m_pParent->m_pLeft == node || node->m_pParent->m_pRight == node);
			// gԂ̏ꍇAe͍
			if( node->m_Color == node_type::RED )
				IRIS_ASSERT( node->m_pParent->m_Color == node_type::BLACK );
		}
		else
		{
			// eȂ == root
			IRIS_ASSERT(node == m_root);
			IRIS_ASSERT(node->m_Color == node_type::BLACK);
		}

		// Ɏqꍇ
		if( !this->is_null_node(node->m_pLeft) )	
		{
			// q̐ê͎͂
			IRIS_ASSERT( node->m_pLeft->m_pParent  == node );
			// gԂ̏ꍇAq͍
			if( node->m_Color == node_type::RED ) 
				IRIS_ASSERT( node->m_pLeft->m_Color == node_type::BLACK );
		}
		// EɎqꍇ
		if( !this->is_null_node(node->m_pRight) )	
		{
			// q̐ê͎͂
			IRIS_ASSERT( node->m_pRight->m_pParent == node );
			// gԂ̏ꍇAq͍
			if( node->m_Color == node_type::RED ) 
				IRIS_ASSERT( node->m_pRight->m_Color == node_type::BLACK );
		}
	}
	/// c[̐
	virtual void	check_tree_root(void) const
	{
		IRIS_ASSERT( static_cast<value_ptr>(null_node())->m_Color == node_type::BLACK);
		check_tree_color(m_root);
		check_tree(m_root);
	}
	/// c[̃J[oX`FbN
	s32			check_tree_color(node_ptr node) const
	{
		if( node == nullptr ) return 0;
		s32 n = node->m_Color == node_type::BLACK ? 1 : 0;
		s32 ln = check_tree_color(node->m_pLeft);
		s32 rn = check_tree_color(node->m_pRight);
		IRIS_ASSERT( ln == rn );
		n += ln;
		return n;
	}
#endif
};


}	// end of namespace fnd
}	// end of namespace iris

#endif

/**
 * @addtogroup	autoexp
 * @{
 * @addtogroup	Visualizer
 * @section		section_autoexp_CRBTree		; iris::fnd::CRBTree
 * @code
;------------------------------------------------------------------------------
; iris::fnd::CRBTree
;------------------------------------------------------------------------------ 
iris::fnd::CRBTree<*> {
	children
	(
		#(
			[actual members]: [$e,!],
			m_root : $e.m_root
		)
	)
	preview
	(
		#(
			[$e,!] 
		)
	)
}
 * @endcode
 * @section		section_autoexp_CRBTreeNode		; iris::fnd::CRBTreeNode
 * @code
;------------------------------------------------------------------------------
; iris::fnd::CRBTreeNode
;------------------------------------------------------------------------------ 
iris::fnd::CRBTreeNode<*> {
	children
	(
		#(
			[actual members]: [$e,!],
			m_pParent : (iris::fnd::CRBTreeNode<$T1>*)$e.m_pParent,
			m_pLeft : (iris::fnd::CRBTreeNode<$T1>*)$e.m_pLeft,
			m_pRight : (iris::fnd::CRBTreeNode<$T1>*)$e.m_pRight,
			m_Color : $e.m_Color,
			m_value : $e.m_value
		)
	)
	preview
	(
		#(
			[$e,!] 
		)
	)
}
 * @endcode
 * @}
*/